/* glpmat/new_elem.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpmat.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- new_elem - create new element of matrix.
--
-- *Synopsis*
--
-- #include "glpmat.h"
-- ELEM *new_elem(MAT *A, int i, int j, double val);
--
-- *Description*
--
-- The new_elem routine creates a new element of the matrix A. This
-- element is placed on ith row and jth column of the matrix, and the
-- value val is assigned to the new element.
--
-- Note that the new_elem routine performs no check whether such
-- element already exists. The routine just inserts the new element to
-- the corresponding row and column linked lists, therefore it may
-- happen that the matrix will have multiplets (i.e. elements that have
-- identical row and column numbers) and/or zeros (i.e. elements that
-- exist and have zero value).
--
-- *Returns*
--
-- The new_elem routine returns a pointer to the created element. */

ELEM *new_elem(MAT *A, int i, int j, double val)
{     ELEM *e;
      if (!(1 <= i && i <= A->m && 1 <= j && j <= A->n))
         fault("new_elem: row or column number out of range");
      e = get_atom(A->pool);
      e->i = i; e->j = j; e->val = val;
      e->row = A->row[i]; e->col = A->col[j];
      A->row[i] = A->col[j] = e;
      return e;
}

/* eof */
