/* glpmat/delete_mat.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpmat.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- delete_mat - delete sparse matrix.
--
-- *Synopsis*
--
-- #include "glpmat.h"
-- void delete_mat(MAT *A);
--
-- *Description*
--
-- The delete_mat routine deletes the matrix A freeing all memory
-- allocated to this object. */

void delete_mat(MAT *A)
{     delete_pool(A->pool);
      ufree(A->row);
      ufree(A->col);
      ufree(A);
      return;
}

/* eof */
