/* glpmat/copy_mat.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpmat.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- copy_mat - copy sparse matrix (B := A).
--
-- *Synopsis*
--
-- #include "glpmat.h"
-- MAT *copy_mat(MAT *B, MAT *A);
--
-- *Description*
--
-- The copy_mat routine copies the sparse matrix A to the sparse matrix
-- B. Both matrix should have identical number of rows and columns. The
-- matrix A remains unchanged.
--
-- *Returns*
--
-- The copy_mat routine returns a pointer to the matrix B. */

MAT *copy_mat(MAT *B, MAT *A)
{     if (!(A->m == B->m && A->n == B->n))
         fault("copy_mat: inconsistent dimension");
      if (A != B)
      {  ELEM *e;
         int i;
         clear_mat(B);
         for (i = 1; i <= A->m; i++)
         {  for (e = A->row[i]; e != NULL; e = e->row)
               new_elem(B, e->i, e->j, e->val);
         }
      }
      return B;
}

/* eof */
