/* glpmat/check_per.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpmat.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- check_per - check permutation matrix for correctness.
--
-- *Synopsis*
--
-- #include "glpmat.h"
-- void check_per(PER *P);
--
-- *Description*
--
-- The check_per routine checks the representation of the permutation
-- matrix P for correctness. In the case of error the routine displays
-- an error message and terminates a program. */

void check_per(PER *P)
{     int i;
      if (P->n < 1)
         fault("check_per: invalid order");
      for (i = 1; i <= P->n; i++)
      {  if (!(1 <= P->row[i] && P->row[i] <= P->n
            && P->col[P->row[i]] == i))
            fault("check_per: invalid representation");
      }
      return;
}

/* eof */
