/* glpduff/delete_duff.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpduff.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- delete_duff - delete Duff's scheme.
--
-- *Synopsis*
--
-- #include "glpduff.h"
-- void delete_duff(DUFF *duff);
--
-- *Description*
--
-- The delete_duff routine deletes the Duff's scheme freeing all memory
-- allocated to this object. */

void delete_duff(DUFF *duff)
{     ufree(duff->len);
      ufree(duff->head);
      ufree(duff->prev);
      ufree(duff->next);
      ufree(duff);
      return;
}

/* eof */
