/* glpavl/find_by_pos.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpavl.h"

/*----------------------------------------------------------------------
-- find_by_pos - search for node placed in given position of AVL-tree.
--
-- *Synopsis*
--
-- #include "glpavl.h"
-- AVLNODE *find_by_pos(AVLTREE *tree, int pos);
--
-- *Description*
--
-- The find_by_pos routine searches for a node that is placed in the
-- given position pos of the AVL-tree. (Do not use this routine to visit
-- all nodes of the AVL-tree, because this is not efficient. It's better
-- to use the next_node or the prev_node routines.)
--
-- *Returns*
--
-- If 1 <= pos <= N, where N = tree.size is the total number of nodes
-- in the AVL-tree, the find_by_pos routine returns a pointer to the
-- node placed in the given position pos. Otherwise the routine returns
-- NULL. */

AVLNODE *find_by_pos(AVLTREE *tree, int pos)
{     AVLNODE *p;
      p = tree->root;
      while (p != NULL)
      {  if (pos == p->rank) break;
         if (pos < p->rank)
            p = p->left;
         else
         {  pos -= p->rank;
            p = p->right;
         }
      }
      return p;
}

/* eof */
