/* glpavl/create_avl.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpavl.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- create_avl - create AVL-tree.
--
-- *Synopsis*
--
-- #include "glpavl.h"
-- AVLTREE *create_avl(int (*comp)(void *, void *));
--
-- The create_avl routine creates an empty AVL-tree that has no nodes.
--
-- The parameter comp specifies a routine to compare node keys (data
-- type to represent keys should be supplied by the user). This routine
-- has the following prototype:
--
-- int comp(void *key1, void *key2);
--
-- where key1 and key2 are pointers to the first key and to the second
-- key respectively that should be compared. This routine should return
-- one of the following values ([p] denotes a value which p points to):
--
-- < 0, if [key1] is less than [key2];
-- = 0, if [key1] and [key2] are identical;
-- > 0, if [key1] is greater than [key2].
--
-- If node keys are character strings, to create AVL-tree the following
-- call may be used:
--
-- ... = create_avl((int (*)(void *, void *))strcmp);
--
-- If the parameter comp is NULL, that is allowed, node keys will not
-- be used, and then searching, inserting, or deleting are possible only
-- by node positions, but not by node keys.
--
-- *Returns*
--
-- The create_avl routine returns a pointer to the created AVL-tree. */

AVLTREE *create_avl(int (*comp)(void *, void *))
{     AVLTREE *tree;
      tree = umalloc(sizeof(AVLTREE));
      tree->pool = create_pool(sizeof(AVLNODE));
      tree->comp = comp;
      tree->size = 0;
      tree->root = NULL;
      tree->height = 0;
      return tree;
}

/* eof */
