/* glpapi/glp_get_seqn.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_get_seqn - get seqn attribute of the current row or column.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- int glp_get_seqn(int what, int *seqn);
--
-- *Description*
--
-- If what = GLP_ROW, the glp_get_seqn routine stores the seqn attribute
-- of the current row to the location pointed by the parameter seqn.
--
-- If what = GLP_COL, the glp_get_seqn routine stores the seqn attribute
-- of the current column to the location pointed by the parameter seqn.
--
-- The seqn attribute is an additional attribute of rows and columns.
-- It is just an integer value, which may be used for any purposes.
-- This attribute is intended mainly for needs of GLPK routines, however
-- it may be used by the application program.
--
-- *Returns*
--
-- 0 - no errors;
-- 1 - the current row/column is undefined;
-- 2 - the parameter what is invalid. */

int glp_get_seqn(int what, int *seqn)
{     if (what == GLP_ROW)
      {  if (glp->this_row == NULL) return 1;
         *seqn = glp->this_row->seqn;
      }
      else if (what == GLP_COL)
      {  if (glp->this_col == NULL) return 1;
         *seqn = glp->this_col->seqn;
      }
      else
      {  /* invalid parameter */
         return 2;
      }
      return 0;
}

/* eof */
