/* glpapi/glp_get_rpar.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <string.h>
#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_get_rpar - get value of real control parameter.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- int glp_get_rpar(char *name, double *val);
--
-- *Description*
--
-- The glp_get_rpar routine stores the value of the real control
-- parameter with the given name to the location, which the parameter
-- val points to.
--
-- See the documentation for descriptions of all control parameters.
--
-- *Returns*
--
-- 0 - no errors;
-- 1 - the given name is invalid. */

int glp_get_rpar(char *name, double *val)
{     if (strcmp(name, "tol_aij") == 0)
      {  /* tolerance used by the solver to drop small elements of the
            constraint matrix */
         *val = glp->tol_aij;
      }
      else if (strcmp(name, "tol_bnd") == 0)
      {  /* tolerance used by the solver to check primal feasibility of
            the current basis solution */
         *val = glp->tol_bnd;
      }
      else if (strcmp(name, "tol_dj") == 0)
      {  /* tolerance used by the solver to check dual feasibility of
            the current basis solution */
         *val = glp->tol_bnd;
      }
      else if (strcmp(name, "tol_piv") == 0)
      {  /* tolerance used by the solver to check pivoting element */
         *val = glp->tol_piv;
      }
      else
      {  /* invalid parameter name */
         return 1;
      }
      return 0;
}

/* eof */
