/* glpapi/glp_get_name.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_get_name - get name of the current row or column.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- int glp_get_name(int what, char *name);
--
-- *Description*
--
-- If what = GLP_ROW, the glp_get_name routine copies the symbolic name
-- of the current row to the character string name.
--
-- If what = GLP_COL, the glp_get_name routine copies the symbolic name
-- of the current column to the character string name.
--
-- Maximal length of symbolic names is 255 characters, so the array name
-- should contain at least 256 locations.
--
-- *Returns*
--
-- 0 - no errors;
-- 1 - the current row or column is undefined;
-- 2 - parameter what is invalid. */

int glp_get_name(int what, char *name)
{     GLPITEM *item;
      if (what == GLP_ROW)
         item = glp->this_row;
      else if (what == GLP_COL)
         item = glp->this_col;
      else
      {  /* invalid parameter */
         return 2;
      }
      if (item == NULL) return 1;
      get_str(name, item->name);
      return 0;
}

/* eof */
