/* glpapi/glp_get_coef.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_get_coef - get value of the current constraint coefficient.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- int glp_get_coef(double *val);
--
-- *Description*
--
-- The glp_get_coef routine stores the value of the current constraint
-- coefficient to the location, which the parameter val points to.
--
-- *Returns*
--
-- 0 - no errors;
-- 1 - the current coefficient is undefined. */

int glp_get_coef(double *val)
{     if (glp->this_coef == NULL) return 1;
      *val = glp->this_coef->val;
      return 0;
}

/* eof */
