/* glpset/error.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include "glpset.h"

int err_flag = 0;

/*----------------------------------------------------------------------
-- error - print error message and continue program execution.
--
-- *Synopsis*
--
-- #include "glpset.h"
-- void error(char *fmt, ...);
--
-- *Description*
--
-- The error routine prints an error message using format control string
-- fmt (like printf) and returns to the calling program.
--
-- If the control variable err_flag is set, the error routine abnormally
-- terminates program execution. */

void error(char *fmt, ...)
{     va_list arg;
      va_start(arg, fmt);
      vfprintf(stderr, fmt, arg);
      va_end(arg);
      fputc('\n', stderr);
      if (err_flag) abort();
      return;
}

/* eof */
