/* glpset/delete_pool.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpset.h"

/*----------------------------------------------------------------------
-- delete_pool - delete memory pool.
--
-- *Synopsis*
--
-- #include "glpset.h"
-- void delete_pool(POOL *pool);
--
-- *Description*
--
-- The delete_pool routine deletes the specified memory pool, returning
-- all memory allocated to the pool to the control program. */

void delete_pool(POOL *pool)
{     void *ptr;
      clear_pool(pool);
      /* now all blocks belong to the free block list */
      while (pool->stock != NULL)
      {  ptr = pool->stock;
         pool->stock = *(void **)ptr;
         ufree(ptr);
      }
      ufree(pool);
      return;
}

/* eof */
