/* glprsm/rsm_invert.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <assert.h>
#include <stddef.h>
#include "glprsm.h"

/*----------------------------------------------------------------------
-- rsm_invert - reinvert basis matrix.
--
-- *Synopsis*
--
-- #include "glprsm.h"
-- int rsm_invert(RSM *rsm);
--
-- *Description*
--
-- The rsm_invert routine reinverts the current basis matrix using some
-- representation of this matrix.
--
-- *Returns*
--
-- If the reinversion was successful, the rsm_invert routine returns
-- zero. Otherwise, it returns non-zero. The latter case can happen if
-- the current basis matrix is numerically singular or ill conditioned.
-- For details see particular routines which perform this operation. */

int rsm_invert(RSM *rsm)
{     int ret;
      if (rsm->efi != NULL)
         ret = build_efi(rsm->efi, rsm->A, rsm->indb);
      else if (rsm->rfi != NULL)
         ret = build_rfi(rsm->rfi, rsm->A, rsm->indb);
      else
         assert(2 + 2 == 5);
      return ret;
}

/* eof */
