/* glpavl/delete_avl.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpavl.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- delete_avl - delete AVL-tree.
--
-- *Synopsis*
--
-- #include "glpavl.h"
-- void delete_avl(AVLTREE *tree);
--
-- *Description*
--
-- The delete_avl routine deletes the AVL-tree freeing all memory
-- allocated to this object. Should note that memory allocated by the
-- user routines to represent keys or any other data connected with
-- nodes will not be freed automatically. */

void delete_avl(AVLTREE *tree)
{       delete_pool(tree->pool);
        ufree(tree);
        return;
}

/* eof */
