/* glpapi/glp_initialize.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_initialize - initialize GLPK application program interface.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- int glp_initialize(void);
--
-- *Description*
--
-- The glp_initialize routine initializes the GLPK application program
-- interface (API).
--
-- This routine should be called once before calls any other GLPK API
-- routines.
--
-- *Returns*
--
-- 0 - no errors;
-- 1 - GLPK API already initialized. */

GLPWKSP *glp = NULL;
/* pointer to the active workspace */

int glp_initialize(void)
{     if (glp != NULL) return 1;
      glp = umalloc(sizeof(GLPWKSP));
      /* --- memory management segment --- */
      glp->str_pool = create_str_pool();
      glp->item_pool = create_pool(sizeof(GLPITEM));
      glp->coef_pool = create_pool(sizeof(GLPCOEF));
      /* --- problem data segment --- */
      glp->row_tab = create_avl((int (*)(void *, void *))compare_str);
      glp->first_row = glp->last_row = glp->this_row = NULL;
      glp->col_tab = create_avl((int (*)(void *, void *))compare_str);
      glp->first_col = glp->last_col = glp->this_col = NULL;
      glp->this_coef = NULL;
      /* --- control parameters segment --- */
      glp->mps_bnd_name[0] = '\0';
      glp->mps_obj_name[0] = '\0';
      glp->mps_one_entry = GLP_NO;
      glp->mps_pedantic = GLP_NO;
      glp->mps_rhs_name[0] = '\0';
      glp->mps_rng_name[0] = '\0';
      glp->mps_skip_empty = GLP_NO;
      glp->mps_use_names = GLP_YES;
      glp->obj_dir = GLP_MIN;
      glp->obj_row = NULL;
      glp->problem = set_str(create_str(glp->str_pool), "UNKNOWN");
      glp->round = GLP_YES;
      glp->scale = GLP_YES;
      glp->spx_form = GLP_RFI_BG;
      glp->spx_relax = GLP_YES;
      glp->spx_steep = GLP_YES;
      glp->spx_use_dual = GLP_NO;
      glp->status = GLP_UNDEF;
      glp->sum_aij = GLP_NO;
      glp->tol_aij = 1e-15;
      glp->tol_bnd = 1e-8;
      glp->tol_dj = 1e-7;
      glp->tol_piv = 1e-10;
      return 0;
}

/* eof */
