/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem;

import gl4java.GLFunc;
import gnu.gleem.HitPoint;
import gnu.gleem.Manip;
import gnu.gleem.ManipPart;
import gnu.gleem.RayTriangleIntersection;
import gnu.gleem.linalg.IntersectionPoint;
import gnu.gleem.linalg.Mat4f;
import gnu.gleem.linalg.Vec3f;
import java.util.List;

public class ManipPartTriBased
extends ManipPart {
    private Vec3f color = new Vec3f(0.8f, 0.8f, 0.8f);
    private Vec3f highlightColor = new Vec3f(0.8f, 0.8f, 0.2f);
    private boolean highlighted = false;
    private boolean pickable = true;
    private boolean visible = true;
    private Vec3f[] vertices = null;
    private Vec3f[] normals = null;
    private int[] vertexIndices = null;
    private int[] normalIndices = null;
    private Mat4f xform = new Mat4f();
    private Vec3f[] curVertices;
    private Vec3f[] curNormals;

    public ManipPartTriBased() {
        this.xform.makeIdent();
        this.curVertices = null;
    }

    public void setColor(Vec3f color) {
        this.color.set(color);
    }

    public Vec3f getColor() {
        return new Vec3f(this.color);
    }

    public void setHighlightColor(Vec3f highlightColor) {
        this.highlightColor.set(highlightColor);
    }

    public Vec3f getHighlightColor() {
        return new Vec3f(this.highlightColor);
    }

    public void intersectRay(Vec3f rayStart, Vec3f rayDirection, List results, Manip caller) {
        this.consistencyCheck();
        if (!this.pickable) {
            return;
        }
        IntersectionPoint intPt = new IntersectionPoint();
        HitPoint hitPt = new HitPoint();
        hitPt.manipulator = caller;
        hitPt.manipPart = this;
        int i = 0;
        while (i < this.vertexIndices.length) {
            int i0 = this.vertexIndices[i];
            int i1 = this.vertexIndices[i + 1];
            int i2 = this.vertexIndices[i + 2];
            if (RayTriangleIntersection.intersectRayWithTriangle(rayStart, rayDirection, this.curVertices[i0], this.curVertices[i1], this.curVertices[i2], intPt) == 2 && intPt.getT() >= 0.0f) {
                hitPt.rayStart = rayStart;
                hitPt.rayDirection = rayDirection;
                hitPt.intPt = intPt;
                results.add(hitPt);
            }
            i += 3;
        }
    }

    public void setTransform(Mat4f xform) {
        this.xform.set(xform);
        this.recalcVertices();
    }

    public void highlight() {
        this.highlighted = true;
    }

    public void clearHighlight() {
        this.highlighted = false;
    }

    public void setPickable(boolean pickable) {
        this.pickable = pickable;
    }

    public boolean getPickable() {
        return this.pickable;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void render(GLFunc gl) {
        if (!this.visible) {
            return;
        }
        boolean lightingOn = true;
        if (lightingOn) {
            gl.glEnable(2903);
            gl.glColorMaterial(1032, 5634);
        }
        gl.glBegin(4);
        if (this.highlighted) {
            gl.glColor3f(this.highlightColor.x(), this.highlightColor.y(), this.highlightColor.z());
        } else {
            gl.glColor3f(this.color.x(), this.color.y(), this.color.z());
        }
        int i = 0;
        while (i < this.vertexIndices.length) {
            Vec3f n0 = this.curNormals[this.normalIndices[i]];
            Vec3f v0 = this.curVertices[this.vertexIndices[i]];
            gl.glNormal3f(n0.x(), n0.y(), n0.z());
            gl.glVertex3f(v0.x(), v0.y(), v0.z());
            Vec3f n1 = this.curNormals[this.normalIndices[++i]];
            Vec3f v1 = this.curVertices[this.vertexIndices[i]];
            gl.glNormal3f(n1.x(), n1.y(), n1.z());
            gl.glVertex3f(v1.x(), v1.y(), v1.z());
            Vec3f n2 = this.curNormals[this.normalIndices[++i]];
            Vec3f v2 = this.curVertices[this.vertexIndices[i]];
            gl.glNormal3f(n2.x(), n2.y(), n2.z());
            gl.glVertex3f(v2.x(), v2.y(), v2.z());
            ++i;
        }
        gl.glEnd();
        if (lightingOn) {
            gl.glDisable(2903);
        }
    }

    protected void setVertices(Vec3f[] vertices) {
        this.vertices = vertices;
    }

    protected Vec3f[] getVertices() {
        return this.vertices;
    }

    protected void setNormals(Vec3f[] normals) {
        this.normals = normals;
    }

    protected Vec3f[] getNormals() {
        return this.normals;
    }

    protected void setVertexIndices(int[] vertexIndices) {
        this.vertexIndices = vertexIndices;
    }

    protected int[] getVertexIndices() {
        return this.vertexIndices;
    }

    protected void setNormalIndices(int[] normalIndices) {
        this.normalIndices = normalIndices;
    }

    protected int[] getNormalIndices() {
        return this.normalIndices;
    }

    private void consistencyCheck() {
        if (this.vertexIndices.length != this.normalIndices.length) {
            throw new RuntimeException("vertexIndices.length != normalIndices.length");
        }
        if (this.vertexIndices.length % 3 != 0) {
            throw new RuntimeException("(vertexIndices % 3) != 0");
        }
        if (this.curVertices != null && this.vertices.length != this.curVertices.length) {
            throw new RuntimeException("vertices.length != curVertices.length");
        }
    }

    private void recalcVertices() {
        int i;
        int i2;
        if (this.curVertices == null || this.curVertices.length != this.vertices.length) {
            this.curVertices = new Vec3f[this.vertices.length];
            i2 = 0;
            while (i2 < this.vertices.length) {
                this.curVertices[i2] = new Vec3f();
                ++i2;
            }
        }
        i2 = 0;
        while (i2 < this.vertices.length) {
            this.xform.xformPt(this.vertices[i2], this.curVertices[i2]);
            ++i2;
        }
        if (this.curNormals == null || this.curNormals.length != this.normals.length) {
            this.curNormals = new Vec3f[this.normals.length];
            i = 0;
            while (i < this.normals.length) {
                this.curNormals[i] = new Vec3f();
                ++i;
            }
        }
        i = 0;
        while (i < this.normals.length) {
            this.xform.xformDir(this.normals[i], this.curNormals[i]);
            this.curNormals[i].normalize();
            ++i;
        }
    }
}

