/* memmove -- copy memory regions of arbitary length
   Copyright (C) 1991 Free Software Foundation, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */


/*

NAME

	memmove -- copy memory regions of arbitary length

SYNOPSIS

	void memmove (void *out, const void *in, size_t n);

DESCRIPTION

	Copy LENGTH bytes from memory region pointed to by IN to memory
	region pointed to by OUT.

	Regions can be overlapping.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>

#ifdef STDC_HEADERS
# include <stdlib.h>
#endif


void *
memmove (out, in, length)
     void *out;
     const void* in;
     size_t length;
{
    bcopy(in, out, length);
    return out;
}
