/*
  EDMA IDFWizard GNOMIZED Version 0.1.0
  Copyright (C) 1998-1999 David Martnez Oliveira
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
 */
/*
 * Revisions:
 * November, 17th, 2001
 * Removing compile warnnings and code cleanup
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>
#include <gnome.h>

#include <edma.h>

#include "generalform.h"


ESint32 InitGeneralForm (GeneralWidgets *gw)
{
  OBJID    id;
  CLASSID  idC;
  EUint32  i,n;
  EChar    fname[512],temp[200],temp1[200],*aux;

  gw->build_form=BuildGeneralForm;
  /* Init lists */
  gw->languages=NULL;
  /* Read Language supported using ID */
  g_print ("[DEBUG] About to create ID object\n");
  id=NewObj("ID",NULL);
  if (id==-1) {
    g_print ("[ERROR] (InitGeneralForm)Can't create ID object\n");
    exit(1);
  }
  GetSystemPath(fname);
  g_print ("System Path : %s",fname);
  strcat (fname,"share/edma/languages_imp.db");
  Met3(id,"SetDB",fname);
  RProp3(id,"nElems",&gw->n);
  for (i=0;i<gw->n;i++)
    {
      Met3(id,"GetItem",i,gw->lang_imp_classes[i],temp,gw->lang_desc[i]);
      gw->languages=g_list_append (gw->languages,gw->lang_desc[i]);
    }
  FreeObj(id);

  id=NewObj("ID",NULL);
  GetSystemPath(fname);
  g_print ("System Path : %s",fname);
  strcat (fname,"share/edma/languages_make.db");
  Met3(id,"SetDB",fname);
  RProp3(id,"nElems",&gw->n);
  for (i=0;i<gw->n;i++)
    {
      Met3(id,"GetItem",i,gw->lang_make_classes[i],temp,temp1);
    }
  FreeObj(id);

  /* Language Processing done */
  gw->sos=NULL;
  gw->sos=g_list_append (gw->sos,"LINUX");
  gw->sos=g_list_append (gw->sos,"Windows 95/98");  
  gw->machines=NULL;
  gw->machines=g_list_append (gw->machines,"i386");
  gw->machines=g_list_append (gw->machines,"i486");
  gw->machines=g_list_append (gw->machines,"Pentium");
  gw->machines=g_list_append (gw->machines,"K6");
  gw->proxies=NULL;
  gw->proxies=g_list_append (gw->proxies,"NONE");
  gw->parsers=NULL;

  n=GetNParsers();
  /* Default parser always available*/
  g_print ("%d parsers in system...\n",n);
  gw->parsers=g_list_append (gw->parsers,"EDMAIDF");
  for (i=1;i<GetNParsers();i++) {
    idC=GetParserClass(i);
    GetClaseName(idC,temp);
    g_print ("Parser %d: %s [%d]\n",i,temp,idC);
    aux=strdup(temp);
    gw->parsers=g_list_append (gw->parsers,aux);
  }
  /*gw->parsers=g_list_append (gw->parsers,"EDMAIDF");*/
  printf ("[DEBUG] General Form succesfully initiated\n");
}

ESint32 BuildGeneralForm (GeneralWidgets *gw,GtkWidget *note)
{   
  GtkWidget *label,*aux;

  /* General Info Page */
  gw->table=gtk_table_new (11,2,FALSE);
  /* Label for options */
  label=gtk_label_new("Class Name");
  gtk_widget_show(label);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), label, 0, 1, 0, 1);
  label=gtk_label_new("Module Name");
  gtk_widget_show(label);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), label, 0, 1, 1, 2);
  label=gtk_label_new("Target Language");
  gtk_widget_show(label);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), label, 0, 1, 2, 3);
  label=gtk_label_new("Operating System");
  gtk_widget_show(label);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), label, 0, 1, 3, 4);
  label=gtk_label_new("Machine");
  gtk_widget_show(label);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), label, 0, 1, 4, 5);
  label=gtk_label_new("SIU Proxy");
  gtk_widget_show(label);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), label, 0, 1, 5, 6);

  label=gtk_label_new("IDF Parser");
  gtk_widget_show(label);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), label, 0, 1, 6, 7);

  /* Entry widgets */
  gw->ClassName=gtk_entry_new();
  gtk_widget_show(gw->ClassName);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->ClassName, 1, 2, 0, 1);
  gw->ModuleName=gtk_entry_new();
  gtk_widget_show(gw->ModuleName);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->ModuleName, 1, 2, 1, 2);
  
  gw->TargetLanguage=gtk_combo_new();
  gtk_combo_set_popdown_strings(GTK_COMBO(gw->TargetLanguage),gw->languages);
  gtk_widget_show(gw->TargetLanguage);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->TargetLanguage, 1, 2, 2, 3);
  
  gw->OS=gtk_combo_new();
  gtk_combo_set_popdown_strings(GTK_COMBO(gw->OS),gw->sos);
  gtk_widget_show(gw->OS);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->OS, 1, 2, 3, 4);
    
  gw->Machine=gtk_combo_new();
  gtk_combo_set_popdown_strings(GTK_COMBO(gw->Machine),gw->machines);
  gtk_widget_show(gw->Machine);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->Machine, 1, 2, 4, 5);
  
  gw->SIUProxy=gtk_combo_new();
  gtk_combo_set_popdown_strings(GTK_COMBO(gw->SIUProxy),gw->proxies);
  gtk_widget_show(gw->SIUProxy);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->SIUProxy, 1, 2, 5, 6);
  
  gw->IDFParser=gtk_combo_new();
  gtk_combo_set_popdown_strings(GTK_COMBO(gw->IDFParser),gw->parsers);
  gtk_widget_show(gw->IDFParser);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->IDFParser, 1, 2, 6, 7);

  gw->IsSIUProxy=gtk_check_button_new_with_label("IsSIUProxy");
  gtk_widget_show(gw->IsSIUProxy);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->IsSIUProxy, 1, 2, 7, 8);

  gw->IsIDFParser=gtk_check_button_new_with_label("IsIDFParser");
  gtk_widget_show(gw->IsIDFParser);
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->IsIDFParser, 1, 2, 8, 9);


  gw->IsEMI=gtk_check_button_new_with_label("IsEMI");
  gtk_widget_show(gw->IsEMI);  
  gtk_table_attach_defaults (GTK_TABLE(gw->table), gw->IsEMI, 1, 2, 9, 10);


  gtk_widget_show(gw->table);
  label=gtk_label_new("General");
  gtk_notebook_insert_page (GTK_NOTEBOOK (note), gw->table, label,0);

  printf ("[DEBUG] General form succesfully created\n");
  return 0;
}

ESint32 GeneralGetClassName(GeneralWidgets *gw,EPChar r)
{
  EPChar temp;

  temp=gtk_entry_get_text (GTK_ENTRY(gw->ClassName));
  strcpy (r,temp);
  return strlen (temp);
}

ESint32 GeneralSetClassName(GeneralWidgets *gw,EPChar r)
{
  gtk_entry_set_text(GTK_ENTRY(gw->ClassName),r);
  return 0;
}
ESint32 GeneralGetModuleName(GeneralWidgets *gw,EPChar r)
{
  EPChar temp;

  temp=gtk_entry_get_text (GTK_ENTRY(gw->ModuleName));
  strcpy (r,temp);
  return strlen (temp);
}

ESint32 GeneralSetModuleName(GeneralWidgets *gw,EPChar r)
{
  gtk_entry_set_text(GTK_ENTRY(gw->ModuleName),r);
  return 0;
}

ESint32 GeneralGetTargetLanguage(GeneralWidgets *gw,EPChar r)
{
  EPChar temp;

  temp=gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(gw->TargetLanguage)->entry));
  strcpy (r,temp);
  return strlen (temp);
}
ESint32 GeneralGetOS(GeneralWidgets *gw,EPChar r)
{
  EPChar temp;

  temp=gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(gw->OS)->entry));
  strcpy (r,temp);
  return strlen (temp);
}
ESint32 GeneralGetMachine(GeneralWidgets *gw,EPChar r)
{
  EPChar temp;

  temp=gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(gw->Machine)->entry));
  strcpy (r,temp);
  return strlen (temp);
}
ESint32 GeneralGetSIUProxy(GeneralWidgets *gw,EPChar r)
{
  EPChar temp;

  temp=gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(gw->SIUProxy)->entry));
  strcpy (r,temp);
  return strlen (temp);
}
ESint32 GeneralGetIDFParser(GeneralWidgets *gw,EPChar r)
{
  EPChar temp;

  temp=gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(gw->IDFParser)->entry));
  strcpy (r,temp);
  return strlen (temp);
}
ESint32 GeneralGetIsProxy (GeneralWidgets *gw)
{
return (GTK_TOGGLE_BUTTON (gw->IsSIUProxy)->active);
}
ESint32 GeneralGetIsParser (GeneralWidgets *gw)
{
return (GTK_TOGGLE_BUTTON (gw->IsIDFParser)->active);
}
ESint32 GeneralGetIsEMI (GeneralWidgets *gw)
{
return (GTK_TOGGLE_BUTTON (gw->IsEMI)->active);
}

