AC_DEFUN(AC_SETUP_RPM,[
AC_PATH_PROG(RPM, rpm, "")
if test "x${RPM}" != "x"; then
  RPM_PATH=`dirname ${RPM}` 
  rpm_ver=`LANG=C ${RPM} --version|sed 's/ *$//;s/^.* //'`.0.0
  AC_MSG_CHECKING("RPM version")
  rpm_ver_major=`echo ${rpm_ver}|cut -d . -f 1`
  rpm_ver_minor=`echo ${rpm_ver}|cut -d . -f 2`
  rpm_ver_rel=`echo ${rpm_ver}|cut -d . -f 3`
  AC_MSG_RESULT("${rpm_ver_major}.${rpm_ver_minor}.${rpm_ver_rel}")
  case ${rpm_ver_major}.${rpm_ver_minor} in
    2.5)
      echo -n "creating rpmrc for rpm-2.5.x... "
      LANG=C ${RPM} --showrc \
      | sed '1,/^RPMRC VALUES:/d' \
      | fgrep -v '(not set)' \
      | egrep -v '^(build|rpm|source|spec|srcrpm|top)dir' \
      | sed "s/optflags *:/& ${host_cpu}/g;s/ *:/:/g" > rpmrc
      sed 's/^ *//' >> rpmrc << EOF
        builddir: `pwd`/BUILD
        sourcedir: `pwd`
        specdir: `pwd`/SPECS
        srcrpmdir: `pwd`/SRPMS
        rpmdir: `pwd`/RPMS
EOF
      RPMFLAGS="${RPMFLAGS} --rcfile rpmrc"
      echo OK
      ;;
    3.0)
      RPMFLAGS="--define '_rpmdir `pwd`/RPMS' ${RPMFLAGS}"
      RPMFLAGS="--define '_sourcedir `pwd`' ${RPMFLAGS}"
      RPMFLAGS="--define '_specdir `pwd`/SPECS' ${RPMFLAGS}"
      RPMFLAGS="--define '_srcrpmdir `pwd`/SRPMS' ${RPMFLAGS}"
      RPMFLAGS="--define '_builddir `pwd`/BUILD' ${RPMFLAGS}"
      ;;
    *)
  esac
fi
AC_SUBST(RPM)
AC_SUBST(RPM_PATH)
AC_SUBST(rpm_ver_major)
AC_SUBST(rpm_ver_minor)
AC_SUBST(rpm_ver_rel)

if test ${target} != ${host} ; then
  case ${rpm_ver_major}.${rpm_ver_minor} in
    2.5)
      RPMFLAGS="${RPMFLAGS} --buildarch ${target_cpu} --buildos ${targt_os}"
      ;;
    3.0)
      RPMFLAGS="${RPMFLAGS} --target=${target}"
      ;;
    *)
  esac
fi
AC_SUBST(RPMFLAGS)
])


dnl
dnl AC_ARG_RPM_PREFIX
dnl 
AC_DEFUN(AC_ARG_RPM_PREFIX,
[dnl
AC_ARG_WITH(rpm_prefix, [  --with-rpm-prefix=RPATH  Prefix for RPM. [/usr]], 
	                           rpm_prefix=$withval,
				   rpm_prefix=/usr)
AC_SUBST(rpm_prefix)]) 
