#! /usr/bin/env perl
#
#	Make two installation subdirectories in a repository and a
#	work subdirectory.  The repository Construct file specifies
#	installation of a script into each install subdirectory.
#	Build in the repository.  Build in the work subdirectory;
#	everything should be up-to-date.  Create a work copy of
#	the Construct file that specifies Install_Local; build;
#	see that the scripts were correctly installed in the work install
#	subdirectories from the repository copies.  Create work copies
#	of the scripts; build; see that the work copies were installed.
#

# $Id: t0146.t,v 1.6 2000/08/18 02:40:14 knight Exp $

# Copyright (c) 1996-2000 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

use Test::Cmd::Cons;
use Config;

$test = Test::Cmd::Cons->new('string' => 'Install_Local');


$test->subdir('work',
		['work', 'xxx'],
		['work', 'yyy'],
		'repository',
		['repository', 'xxx'],
		['repository', 'yyy']);

#
$workpath_repository = $test->workpath('repository');
$workpath_repository_xxx_foo_pl = $test->workpath('repository', 'xxx', 'foo.pl');
$workpath_work_xxx_foo_pl = $test->workpath('work', 'xxx', 'foo.pl');
$workpath_repository_yyy_bar_pl = $test->workpath('repository', 'yyy', 'bar.pl');
$workpath_work_yyy_bar_pl = $test->workpath('work', 'yyy', 'bar.pl');

$flags = "-R $workpath_repository";

#
$test->write(['repository', 'Construct'], <<_EOF_);
\%env_hash = ( ${\$test->cons_env} );
\$env_hash{PLSUFFIX} = 'pl';
\$env_hash{INSTDIR} = 'yyy';
\$env = new cons ( \%env_hash );
Install \$env 'xxx', 'foo.\%PLSUFFIX';
Install \$env '\%INSTDIR', 'bar.pl';
_EOF_

$test->write(['repository', 'foo.pl'], <<_EOF_);
$Config{startperl}
print "repository/foo.pl called with arg 0 = '\$0'\\n";
_EOF_

$test->write(['repository', 'bar.pl'], <<_EOF_);
$Config{startperl}
print "repository/bar.pl called with arg 0 = '\$0'\\n";
_EOF_


$test->run('chdir' => 'repository', targets => ".");

$test->execute(prog => $workpath_repository_xxx_foo_pl, interpreter => $^X, stdout => <<_EOF_);
repository/foo.pl called with arg 0 = '\Q$workpath_repository_xxx_foo_pl\E'
_EOF_

$test->execute(prog => $workpath_repository_yyy_bar_pl, interpreter => $^X, stdout => <<_EOF_);
repository/bar.pl called with arg 0 = '\Q$workpath_repository_yyy_bar_pl\E'
_EOF_

# Make the repository non-writable,
# so we'll detect if we try to write into it accidentally.
$test->writable('repository', 0);

$test->up_to_date('chdir' => 'work', flags => $flags, targets => ".");
$test->must_not_exist($workpath_work_xxx_foo_pl);

$test->write(['work', 'Construct'], <<_EOF_);
\%env_hash = ( ${\$test->cons_env} );
\$env_hash{INSTDIR} = 'yyy';
\$env = new cons ( \%env_hash );
Install_Local \$env 'xxx', 'foo.pl';
Install_Local \$env '\%INSTDIR', 'bar.pl';
_EOF_

$test->run('chdir' => 'work', flags => $flags, targets => ".");

$test->execute(prog => $workpath_work_xxx_foo_pl, interpreter => $^X, stdout => <<_EOF_);
repository/foo.pl called with arg 0 = '\Q$workpath_work_xxx_foo_pl\E'
_EOF_

$test->execute(prog => $workpath_work_yyy_bar_pl, interpreter => $^X, stdout => <<_EOF_);
repository/bar.pl called with arg 0 = '\Q$workpath_work_yyy_bar_pl\E'
_EOF_

$test->write(['work', 'foo.pl'], <<_EOF_);
$Config{startperl}
print "work/foo.pl called with arg 0 = '\$0'\\n";
_EOF_

$test->run('chdir' => 'work', flags => $flags, targets => ".");

$test->execute(prog => $workpath_work_xxx_foo_pl, interpreter => $^X, stdout => <<_EOF_);
work/foo.pl called with arg 0 = '\Q$workpath_work_xxx_foo_pl\E'
_EOF_

#
$test->pass;
__END__
