#! /usr/bin/env perl
#
#	Create a Construct file that does nothing more than call the
#	internal File::Spec->splitpath() method with some hard-coded
#	path names and prints the split results.  Run Cons and check
#	the output.
#

# $Id: t0078.t,v 1.1 2000/08/18 21:08:10 knight Exp $

# Copyright (c) 1996-2000 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

use Test::Cmd::Cons qw($_is_win32);

$test = Test::Cmd::Cons->new(string => 'UNC path names');

# This test only applies to WIN32 systems,
# so just pass it on other systems.
$test->pass if ! $_is_win32;

#
$test->write('Construct', <<_EOF_);
\@paths = qw(
	\\\\\\\\foo\\bar\\path\\name
	//foo/bar/path/name
);
foreach \$path (\@paths) {
	my (\$vol, \$dirs, \$file) = File::Spec->splitpath(\$path);
	print \$path, "\\n";
	print "\\t<", \$vol, "> <", \$dirs, "> <", \$file, ">\\n";
}
_EOF_

#
$test->run(targets => '', stdout => <<'_EOF_');
\\\\foo\\bar\\path\\name
	<\\\\foo\\bar> <\\path\\> <name>
//foo/bar/path/name
	<//foo/bar> </path/> <name>
_EOF_

#
$test->pass;
__END__
