#! /usr/bin/env perl
#
#	Create two files in the current directory and two files in a
#	subdirectory by copying input files to output files.  One file
#	in each directory begins with a '.'.  Run Cons; make sure all
#	files were created.
#

# $Id: t0077.t,v 1.2 2000/09/10 05:01:27 knight Exp $

# Copyright (c) 1996-2000 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

use Test::Cmd::Cons;

$test = Test::Cmd::Cons->new(string => '.filenames');

$test->subdir('subdir');

#
$subdir_Conscript = $test->catfile('subdir', 'Conscript');
$subdir_ccc = $test->catfile('subdir', 'ccc');
$subdir__ddd = $test->catfile('subdir', '.ddd');

#
$test->write('Construct', <<_EOF_);
\$env = new cons ( ${\$test->cons_env} );
Command \$env 'aaa', 'aaa.in', qq(
	\Q$^X\E -e "use File::Copy; copy('%<', '%>'); exit 0"
);
Command \$env '.bbb', 'bbb.in', qq(
	\Q$^X\E -e "use File::Copy; copy('%<', '%>'); exit 0"
);
Export qw( env );
Build qw( $subdir_Conscript );
_EOF_

$test->write('aaa.in', <<'_EOF_');
aaa.in
_EOF_

$test->write('bbb.in', <<'_EOF_');
bbb.in
_EOF_

$test->write(['subdir', 'Conscript'], <<_EOF_);
Import qw( env );
Command \$env 'ccc', 'ccc.in', qq(
	\Q$^X\E -e "use File::Copy; copy('%<', '%>'); exit 0"
);
Command \$env '.ddd', 'ddd.in', qq(
	\Q$^X\E -e "use File::Copy; copy('%<', '%>'); exit 0"
);
_EOF_

$test->write(['subdir', 'ccc.in'], <<'_EOF_');
ccc.in
_EOF_

$test->write(['subdir', 'ddd.in'], <<'_EOF_');
ddd.in
_EOF_

#
$test->run(targets => ".");

$test->must_exist('aaa');
$test->must_exist('.bbb');
$test->must_exist($subdir_ccc);
$test->must_exist($subdir__ddd);

#
$test->pass;
__END__
