#! /usr/bin/env perl
#
#	Create a Precious output file by using a script to append the
#	contents of an input file.  Build the output file; make sure
#	its contents are correct.  Change the input file, and change the
#	script to fail.  Re-build the output file; make sure it didn't
#	change at all.	Change the script to append the contents again.
#	Re-build the output file, and make sure contents that didn't
#	get appended on the previous re-build are now there.
#

# $Id: t0063.t,v 1.4 2000/08/03 02:20:38 knight Exp $

# Copyright (c) 1996-2000 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

use Test::Cmd::Cons;
use Config;

$test = Test::Cmd::Cons->new(string => 'Precious, build failure');

#
$test->write('build.pl', <<_EOF_);
$Config{startperl}
while (<>) {
	print
}
exit(0);
_EOF_

$test->write('Construct', <<_EOF_);
\$env = new cons ( ${\$test->cons_env} );
Precious 'output';
Command \$env 'output', 'input', qq(
	\Q$^X\E build.pl %< >> %>
);
_EOF_

$test->write('input', <<_EOF_);
input #1
_EOF_

$test->run(targets => ".");

$test->file_matches('output', <<_EOF_);
input #1
_EOF_

$test->write('input', <<_EOF_);
input #2
_EOF_

$test->write('build.pl', <<_EOF_);
$Config{startperl}
exit(1);
_EOF_

$test->run(targets => ".", fail => '$? == 0', stderr => <<_EOF_); # expect failure
\Q${\$test->basename}\E: \Q*** [output] Error 1\E
\Q${\$test->basename}\E: errors constructing output
_EOF_

$test->file_matches('output', <<_EOF_);
input #1
_EOF_

$test->write('build.pl', <<_EOF_);
$Config{startperl}
while (<>) {
	print
}
exit(0);
_EOF_

$test->run(targets => ".");

$test->file_matches('output', <<_EOF_);
input #1
input #2
_EOF_

#
$test->pass;
__END__
