#! /usr/bin/env perl
#
#	Create two Programs, one in a subdirectory, each from three
#	object files.  For each Program, the object files are listed
#	via the Objects method, one in the local directory, one in
#	a subdirectory, and the last in sub-subdirectory.  Build the
#	Programs and make sure they built correctly.
#

# $Id: t0061.t,v 1.7 2000/09/27 20:01:55 knight Exp $

# Copyright (c) 1996-2000 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

use Test::Cmd::Cons;

$test = Test::Cmd::Cons->new(string => 'Objects');

$test->subdir(	'absolute',
		'work',
		['work', 'export'],
		['work', 'sub'],
		['work', 'sub', 'dir'],
		['work', 'src'],
		['work', 'src', 'sub'],
		['work', 'src', 'sub', 'dir']);

#
$src_bar = $test->catfile('src', 'bar');
$src_Conscript = $test->catfile('src', 'Conscript');

$sub_dir = $test->catfile('sub', 'dir');
$sub_dir_bbb_c = $test->catfile('sub', 'dir', 'bbb.c');
$sub_ccc_c = $test->catfile('sub', 'ccc.c');

$work_foo = $test->catfile('work', 'foo');
$work_src_bar = $test->catfile('work', $src_bar);

$absolute_fff_c = $test->workpath('absolute', 'fff.c');

#
$test->write(['work', 'Construct'], <<_EOF_);
\%env_hash = ( ${\$test->cons_env} );
\$env_hash{SUB} = 'sub';
\$env_hash{SUB_DIR} = '$sub_dir';
\$env = new cons ( \%env_hash );
Export qw( env );
\@ofiles = Objects \$env
	'foo.c',
	'%SUB/aaa.c',
	'$sub_dir_bbb_c',
	'#export/eee.c',
	'$absolute_fff_c';
Program \$env 'foo', \@ofiles;
Build '$src_Conscript';
_EOF_

$test->write(['work', $src_Conscript], <<_EOF_);
Import qw( env );
\@ofiles = Objects \$env
	'bar.c',
	'$sub_ccc_c',
	'%SUB_DIR/ddd.c',
	'#export/eee.c',
	'$absolute_fff_c';
Program \$env 'bar', \@ofiles;
_EOF_

$test->write(['work', 'foo.c'], <<'_EOF_');
extern void aaa(void);
extern void bbb(void);
int
main(int argc, char *argv[])
{
	aaa();
	bbb();
	eee();
	fff();
	printf("foo.c\n");
	exit (0);
}
_EOF_

$test->write(['work', 'sub', 'aaa.c'], <<'_EOF_');
void
aaa(void)
{
	printf("sub/aaa.c\n");
}
_EOF_

$test->write(['work', 'sub', 'dir', 'bbb.c'], <<'_EOF_');
void
bbb(void)
{
	printf("sub/dir/bbb.c\n");
}
_EOF_

$test->write(['work', 'src', 'bar.c'], <<'_EOF_');
extern void ccc(void);
extern void ddd(void);
int
main(int argc, char *argv[])
{
	ccc();
	ddd();
	eee();
	fff();
	printf("src/bar.c\n");
	exit (0);
}
_EOF_

$test->write(['work', 'src', 'sub', 'ccc.c'], <<'_EOF_');
void
ccc(void)
{
	printf("src/sub/ccc.c\n");
}
_EOF_

$test->write(['work', 'src', 'sub', 'dir', 'ddd.c'], <<'_EOF_');
void
ddd(void)
{
	printf("src/sub/dir/ddd.c\n");
}
_EOF_

$test->write(['work', 'export', 'eee.c'], <<'_EOF_');
void
eee(void)
{
	printf("export/eee.c\n");
}
_EOF_

$test->write(['absolute', 'fff.c'], <<'_EOF_');
void
fff(void)
{
	printf("absolute/fff.c\n");
}
_EOF_

#
$test->run('chdir' => 'work', targets => ".");

$test->execute(prog => $work_foo, stdout => <<_EOF_);
sub/aaa.c
sub/dir/bbb.c
export/eee.c
absolute/fff.c
foo.c
_EOF_

$test->execute(prog => $work_src_bar, stdout => <<_EOF_);
src/sub/ccc.c
src/sub/dir/ddd.c
export/eee.c
absolute/fff.c
src/bar.c
_EOF_

$test->pass;
__END__
