#! /usr/bin/env perl
#
#	Define a scalar variable and Export it to a subsidiary Conscript
#	file for printing.  Run Cons and make sure the variable was
#	exported and printed correctly.  Rewrite the Construct file to
#	Export the variable but not define it.	Run Cons and see that it
#	failed with the expected error.  Rewrite the Construct file again
#	to not Export the variable.  Run Cons and see that it failed
#	with the expected variable.  Define a scalar $ENV variable and
#	try to Export it.  Run Cons and see that it detects the special
#	Perl variable and dies with the expected message.
#

# $Id: t0007.t,v 1.6 2000/10/25 21:27:22 knight Exp $

# Copyright (c) 1996-2000 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

use Test::Cmd::Cons;

$test = Test::Cmd::Cons->new(string => 'Export / Import');

#
$test->write("Construct", <<'_EOF_');
$var = 111;
Export qw( var );
Build qw( Conscript );
_EOF_

$test->write('Conscript', <<'_EOF_');
Import qw( var );
print "Conscript:  $var\n";
_EOF_

$test->run(stdout => <<_EOF_);
Conscript:  111
_EOF_

#
$test->write("Construct", <<'_EOF_');
Export qw( var );
Build qw( Conscript );
_EOF_

$test->run(fail => '$? == 0', stdout => <<_EOF_, stderr => <<_EOF_);
\Q${\$test->basename}\E: error in file "Conscript" \\(\Q${\$test->basename}\E: variable "var" exported but not defined by file "Construct"\\)
_EOF_
\Q${\$test->basename}\E: script errors encountered: construction aborted
_EOF_

#
$test->write("Construct", <<'_EOF_');
Build qw( Conscript );
_EOF_

$test->run(fail => '$? == 0', stdout => <<_EOF_, stderr => <<_EOF_);
\Q${\$test->basename}\E: error in file "Conscript" \\(\Q${\$test->basename}\E: variable "var" not exported by file "Construct"\\)
_EOF_
\Q${\$test->basename}\E: script errors encountered: construction aborted
_EOF_

#
$test->write("Construct", <<'_EOF_');
$ENV = 444;
Export qw( ENV );
Build qw( Conscript );
_EOF_

$test->write('Conscript', <<'_EOF_');
Import qw( ENV );
print "Conscript:  $ENV\n";
_EOF_

$test->run(fail => '$? == 0', stdout => <<_EOF_, stderr => <<_EOF_);
\Q${\$test->basename}\E: error in file "Construct" \\(\Q${\$test->basename}\E: cannot Export special Perl variables: ENV\\)
_EOF_
\Q${\$test->basename}\E: script errors encountered: construction aborted
_EOF_

$test->pass;
__END__
