/* cfengine for GNU
 
        Copyright (C) 1995
        Free Software Foundation, Inc.
 
   This file is part of GNU cfengine - written and maintained 
   by Mark Burgess, Dept of Computing and Engineering, Oslo College,
   Dept. of Theoretical physics, University of Oslo
 
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
 

/*******************************************************************/
/*                                                                 */
/*  HEADER for cfd - Not generically includable!                   */
/*                                                                 */
/*******************************************************************/

extern FILE *yyin;

#define queuesize 20
#define connection 1
#define CFD_INPUT "cfd.conf"

/**********************************************************************/

char *COMMANDS[] =
   {
   "EXEC",
   "AUTH",
   "GET",
   "OPENDIR",
   "SYNCH",
   "CLASSES",
   "MD5",
   NULL
   };

enum COMMS
   {
   cfd_exec,
   cfd_auth,
   cfd_get,
   cfd_opendir,
   cfd_synch,
   cfd_classes,
   cfd_md5,
   cfd_bad
   };

struct cfd_connection
   {
   int id_verified;
   int synchronized;
   int sd_reply;
   char hostname[maxvarsize];
   };

struct cfd_thread_arg
   {
   struct cfd_connection *connect;
   char *replybuff;
   char *replyfile;
   };

/*******************************************************************/
/* GLOBAL VARIABLES                                                */
/*******************************************************************/

int CLOCK_DRIFT = 1000;
int CFD_MAXPROCESSES = 0;
int ACTIVE_THREADS = 0;
int NO_FORK = false;
int MULTITHREAD = false;
int CFD_INTERVAL = 0;

struct option CFDOPTIONS[] =
   {
   { "help",no_argument,0,'h' },
   { "debug",optional_argument,0,'d' }, 
   { "verbose",no_argument,0,'v' },
   { "no-fork",no_argument,0,'F' },
   { "parse-only",no_argument,0,'p'},
   { "multithread",no_argument,0,'m'},
   { NULL,0,0,0 }
   };

/*******************************************************************/
/* PARSER                                                          */
/*******************************************************************/

char CURRENTPATH[bufsize];
char CFRUNCOMMAND[bufsize];
char CHECKSUMDB[bufsize];
time_t CFDSTARTTIME;

#ifdef RE_DUP_MAX
# undef RE_DUP_MAX
#endif

/*******************************************************************
 * Sunos4.1.4 need these prototypes
 *******************************************************************/

#if defined(SUN4)
extern char *realpath(/* char *path; char resolved_path[MAXPATHLEN] */);
#endif

/* Need this to to avoid conflict with solaris 2.6 and db.h */

#ifdef SOLARIS
# define u_int32_t uint32_t
# define u_int16_t uint16_t
# define u_int8_t uint8_t
#endif
