// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "server.h"
#include <ctype.h>

FifoHandler *FifoHandler::first = NULL;
Fifo fifo;

static Trunk *getTrunk(char *str)
{
	if(!str)
		return NULL;

	return driver->getTrunkPort(atoi(str));
}

bool Fifo::waitPid(char **argv)
{
	Trunk *trunk = getTrunk(argv[1]);
	if(!trunk)
		return false;

	if(!argv[2])
		return false;

	trunk->tgi.pid = atoi(argv[2]);
	return true;
}

bool Fifo::setSymbol(char **argv)
{
	Trunk *trunk = getTrunk(argv[1]);
	if(!trunk)
		return false;

	if(!argv[3] || !argv[2])
		return false;

	trunk->setSymbol(argv[2], trunk->getSymbolSize());
	trunk->setSymbol(argv[2], argv[3]);
	return true;
}

bool Fifo::submit(char **argv)
{
	Trunk *trunk = getTrunk(argv[1]);
	char buffer[512];
	strstream str(buffer, 512);
	TrunkEvent event;
	int argc = 3;
	unsigned seq;

	if(!trunk || !argv[2])
		return false;

	seq = atoi(argv[2]);
	while(argv[argc])
	{
		if(argc > 3)
			str << '&';
		str << argv[argc++];
	}
	str << ends;
	event.id = TRUNK_SERVICE_LOOKUP;
	event.parm.lookup.seq = seq;
	event.parm.lookup.result = true;
	event.parm.lookup.data = buffer;
	return trunk->postEvent(&event);
}


bool Fifo::ringScript(char **argv)
{
	Trunk *trunk = getTrunk(argv[1]);
	TrunkEvent event;

	if(!trunk || !argv[2])
		return false;

	event.id = TRUNK_RING_START;
	event.parm.argv = &argv[2];

	return trunk->postEvent(&event);
}

bool Fifo::reqScript(char **argv)
{
	int argc = 4;
	char buffer[512];
	strstream str(buffer, sizeof(buffer));
	TrunkGroup *grp;
	char *exp = argv[1];
	
	if(!exp || !argv[2])
		return false;

	grp = getGroup(argv[2]);
	if(!grp || !argv[3])
		return false;

	buffer[0] = 0;
	str << argv[3];
	while(argv[argc])
		str << " " << argv[argc++];

	str << ends;
	new Request(grp, buffer, atoi(exp));
	return true;
}

bool Fifo::startScript(char **argv)
{
	Trunk *trunk = getTrunk(argv[1]);	
	TrunkEvent event;
	
	if(!trunk || !argv[2])
		return false;

	event.id = TRUNK_START_SCRIPT;
	event.parm.argv = &argv[2];

	return trunk->postEvent(&event);
}

bool Fifo::exitPid(char **argv)
{
	Trunk *trunk = getTrunk(argv[1]);
	TrunkEvent event;

	if(!trunk)
		return false;

	event.id = TRUNK_EXIT_SHELL;
	if(argv[2])
		event.parm.status = atoi(argv[2]);
	else
		event.parm.status = 0;

	return trunk->postEvent(&event);
}

bool Fifo::hangupLine(char **argv)
{
	Trunk *trunk = getTrunk(argv[1]);
	TrunkEvent event;

	if(!trunk)
		return false;

	event.id = TRUNK_STOP_DISCONNECT;
	return trunk->postEvent(&event);
}

bool Fifo::busyLine(char **argv)
{
	Trunk *trunk = getTrunk(argv[1]);
	TrunkEvent event;

	if(!trunk)
		return false;

	event.id = TRUNK_MAKE_BUSY;
	return trunk->postEvent(&event);
}

bool Fifo::idleLine(char **argv)
{
	Trunk *trunk = getTrunk(argv[1]);
	TrunkEvent event;

	if(!trunk)
		return false;

	event.id = TRUNK_MAKE_IDLE;
	return trunk->postEvent(&event);
}

bool Fifo::mapFiles(char **argv)
{
	int count = 0;
	char pathname[128];

	while(*(++argv))
	{
		strcpy(pathname, "maps/");
		strcat(pathname, *argv);
		strcat(pathname, ".map");
		if(!canAccess(pathname))
			continue;
		new Map(pathname, *argv);
		++count;
	}
	if(count)
		return true;
	else
		return false;
}
		
bool Fifo::Command(const char *cmd)
{
	FifoHandler *next;
	char buffer[512];
	bool rts = false;
	char *argv[65];
	int argc = 0;
	char *arg;
	char *sp;
	char *ptr;
	const char *token = keyserver.getToken();
	int tlen = strlen(token);

	strncpy(buffer, cmd, sizeof(buffer) - 1);
	buffer[sizeof(buffer) - 1] = 0;

	EnterMutex();
	slog(SLOG_DEBUG) << "fifo: cmd=" << cmd << endl;
	if(strstr(buffer, token))
	{
		ptr = buffer;
		while(isspace(*ptr))
			++ptr;
	
		ptr = strtok_r(ptr, "\n", &sp);	
		while(NULL != (sp = strstr(ptr, token)))
		{
			argv[argc++] = ptr;
			*sp = 0;
			ptr = sp + tlen;
		}
		while(isspace(*ptr))
			++ptr;
		if(*ptr)
			argv[argc++] = ptr;
	}
	else
	{
		argv[argc++] = strtok_r(buffer, " \t\n\r", &sp);
		while(argc < 64)
		{
			arg = strtok_r(NULL, " \t\n\r", &sp);
			if(!arg)
				break;
			argv[argc++] = arg;
		}
	}
	argv[argc] = NULL;

	if(!argv[0])
	{
		LeaveMutex();
		return false;
	}

	if(!*argv[0])
	{
		LeaveMutex();
		return false;
	}

	next = FifoHandler::first;

	while(next && !rts)
	{
		rts = next->Command(argv);
		next = next->next;
	}

	if(!stricmp(argv[0], "down"))
	{
		raise(SIGINT);
		rts = true;
	}
	else if(!stricmp(argv[0], "compile"))
	{
		driver->getImage();
		rts = true;
	}		
	else if(!stricmp(argv[0], "wait"))
		rts = waitPid(argv);
	else if(!stricmp(argv[0], "exit"))
		rts = exitPid(argv);
	else if(!stricmp(argv[0], "set"))
		rts = setSymbol(argv);
	else if(!stricmp(argv[0], "submit"))
		rts = submit(argv);
	else if(!stricmp(argv[0], "debug"))
		rts = debug->DebugFifo(argv);
	else if(!stricmp(argv[0], "ring"))
		rts = ringScript(argv);
	else if(!stricmp(argv[0], "busy"))
		rts = busyLine(argv);
	else if(!stricmp(argv[0], "idle"))
		rts = idleLine(argv);
	else if(!stricmp(argv[0], "start"))
		rts = startScript(argv);	
	else if(!stricmp(argv[0], "request"))
		rts = reqScript(argv);
	else if(!stricmp(argv[0], "disconnect") || !stricmp(argv[0], "hangup"))
		rts = hangupLine(argv);
	else if(!stricmp(argv[0], "map"))
		rts = mapFiles(argv);
	LeaveMutex();
	return rts;
}

FifoHandler::FifoHandler()
{
	next = first;
	first = this;
}

