// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "server.h"

Server *Server::first = NULL;
Audit *Audit::first = NULL;
Auditdata Audit::keys;
Translator *Translator::first = NULL;
TGI *TGI::first = NULL;
Module *Module::first = NULL;
Sync *Sync::first = NULL;

Auditdata::Auditdata()
{
	Load("/bayonne/audit");
	Load("~bayonne/audit");
}

Audit::Audit() :
Mutex()
{
	next = first;
	first = this;
}

Driver::Driver() :
aaScript()
{
	active = false;
	if(driver)
		throw(this);

	groups = NULL;
	driver = this;
	status = NULL;
}

aaImage *Driver::getImage(void)
{
	return new aaImage((aaScript *)this);
}

void Driver::getStatus(char *buffer)
{
	if(!status)
		return;

	memcpy(buffer, status, getTrunkCount());
}

void Functions::Load(FUNCTIONS *map)
{
	int count = 0;
	while(map->name)
	{
		driver->addFunction(map->name, map->function);
		++map;
		++count;
	}
	slog(SLOG_DEBUG) << getName() << ": loaded " << count << " functions" << endl;
}

void audit(char *detail)
{
	Audit *au = Audit::first;

	while(au)
	{
		au->Report(detail);
		au = au->next;
	}
}

Debug::Debug() :
Mutex()
{
	if(debug)
		throw this;

	debug = this;
}

Translator::Translator(const char *conf, const char *lib) :
Keydata(conf)
{
	char keypath[33];
	next = first;
	first = this;

	if(lib)
		Load(lib);

	slog(SLOG_DEBUG) << "loaded lib" << endl;
	if(isDir("/etc/bayonne.d"))
		if(canAccess("/etc/bayonne.d"))
			scanDir(conf, lib);

	strcpy(keypath, conf);
	*keypath = '~';
	Load(keypath);

	if(!lib)
		return;

	strcpy(keypath, lib);
	*keypath = '~';
	Load(keypath);
}

void Translator::scanDir(const char *lang, const char *lib)
{
	char buffer[65];
	char *name, *ext;
	Dir dir("/etc/bayonne.d");
	if(*lang == '/')
		lang = strrchr(lang, '/');

	if(lib)
		if(*lib == '/')
			lib = strrchr(lib, '/');

	while(NULL != (name = dir.getName()))
	{
		ext = strrchr(name, '.');
		if(!ext)
			continue;

		if(strcmp(ext, ".conf"))
			continue;

		strcpy(buffer, "/bayonne.d/");
		*ext = 0;
		strcat(buffer, name);
		strcat(buffer, lang);
		Load(buffer);
		if(!lib)
			continue;
		strcpy(buffer, "/bayonne.d/");
		strcat(buffer, name);
		strcat(buffer, "lib");
		Load(buffer);
	}
}

char *Translator::getPlayBuffer(Trunk *trunk)
{
	char *pbuf;
	
	pbuf = trunk->data.play.list;
	trunk->data.play.name = pbuf;
	trunk->data.play.limit = trunk->data.play.offset = 0;
	*pbuf = 0;
	return pbuf;
}

Translator *getTranslator(char *name)
{
	Translator *trans = Translator::first;

	while(trans)
	{
		if(!stricmp(name, trans->getName()))
			return trans;
		trans = trans->next;
	}
	return NULL;
}

Sync::Sync()
{
	next = first;
	first = this;
	time(&runtime);
}

Server::Server(int pri) :
Thread(NULL, pri, keythreads.getStack())
{
	next = first;
	first = this;
}

void startServers(void)
{
	Server *server = Server::first;

	while(server)
	{
		server->Start();
		server = server->next;
	}
}

void stopServers(void)
{
	Server *server = Server::first;

	while(server)
	{
		server->Stop();
		server = server->next;
	}
}

PortManager::PortManager(Trunk *trk)
{
	trunk = trk;
	trunk->manager = this;
}

TGI::TGI()
{
	next = first;
	first = this;
}

TGI *getInterp(char *cmd)
{
	TGI *tgi = TGI::first;
	char *ext;
	char buffer[512];
	strcpy(buffer, cmd);
	cmd = strtok_r(buffer, " \t\n", &ext);
	ext = strrchr(cmd, '.');
	
	while(tgi)
	{
		if(tgi->getExtension(ext))
			return tgi;
		tgi = tgi->next;
	}
	return NULL;
}

void getInterp(char *cmd, char **args)
{
	TGI *tgi = TGI::first;

	while(tgi)
	{
		tgi->Script(cmd, args);
		tgi = tgi->next;
	}
}

Module::Module()
{
	next = first;
	first = this;
}

Module *getModule(modtype_t mtype, const char *name)
{
	Module *mod = Module::first;

	while(mod)
	{
		if(mod->getType() == mtype)
		{
			if(!name)
				return mod;

			if(!stricmp(name, mod->getName()))
				return mod;
		}
		mod = mod->next;
	}
	return NULL;
}

Debug *debug = NULL;
Driver *driver = NULL;
