// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Bayonne as noted here.
//
// This exception is that permission is hereby granted to link Bayonne 
// with the Aculab telephony libraries to produce a executable image
// without requiring Aculab's libraries to be supplied in a free software
// license as long as each source file so linked contains this exclusion
// and the unalrtered Aculab source files are made available.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name Bayonne.  If you copy code from other releases into a copy of
// Bayonne, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to Bayonne, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <ivrconfig.h>
#include <bayonne.h>
#include <cc++/audio.h>

extern "C" {

#include <aculab/mvcldrvr.h>
#include <aculab/mvswdrvr.h>
#include <aculab/smport.h>
#include <aculab/smbesp.h>
#include <aculab/smhlib.h>
#include <aculab/smwavlib.h>
#include <aculab/smosintf.h>
#include <aculab/smdrvr.h>

};

#define	MAXTIMESLOTS	32
#define MAXCHANNELS	30

typedef enum
{
	INVALID_PORT,
	FAILED_PORT,
	PRI_PORT,
	BRI_PORT
}	interface_t;

class AculabTrunk;

typedef bool (AculabTrunk::*trunkhandler_t)(TrunkEvent *event);

class AculabTrunk : private Trunk, private Thread
{
private:
	friend class AculabDriver;
	static char status[MAXPORT * MAXTIMESLOTS];

	trunkhandler_t handler;
	time_t lastring;
	int evbuf[2];
	int port, ts, handle, lcn;

	bool postEvent(TrunkEvent *evt);
	void putEvent(TrunkEvent *evt);
	void Run(void);
	void Exit(void);
	void getName(char *buffer);
	unsigned long getIdleTime(void);

	// since we have no state handlers yet, null this out...
	void TrunkStep(trunkstep_t step)
		{return;};

	AculabTrunk(int port, int ts);
	~AculabTrunk();
};

class AculabConfig : public Keydata
{
public:
	AculabConfig();

	unsigned getMaxPorts(void);

	inline const char *getPriFirmware(void)
		{return getLast("prifirmware");};

	inline const char *getPriConfig(void)
		{return getLast("priconfig");};

	inline const char *getBriFirmware(void)
		{return getLast("brifirmware");};

	inline const char *getBriConfig(void)
		{return getLast("briconfig");};

	inline const char *getProsody(void)
		{return getLast("prosody");};
};

class AculabDriver : public Driver, public AculabConfig, public Thread
{
private:
	friend class AculabTrunk;

	interface_t interfaces[MAXPORT];
	struct siginfo_xparms siginfo[MAXPORT];

	AculabTrunk **trunks;
	AculabTrunk **maps;
	int port_count, pri_count, bri_count;
	bool running;

	bool InitNetworks(void);
	bool InitProsody(void);

	void setChannel(AculabTrunk *trunk);
	void clrChannel(AculabTrunk *trunk);

public:
	AculabDriver();
	~AculabDriver();

	int Start(void);
	void Stop(void);
	void Run(void);

	int getTrunkCount(void)
		{return port_count * MAXTIMESLOTS;};

	Trunk *getTrunkPort(int id);
	aaScript *getScript(void);

	unsigned getPort(int id)
		{return id / MAXTIMESLOTS;};

	interface_t getInterface(unsigned port);
};

extern AculabDriver aculabivr;
