// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Bayonne as noted here.
//
// This exception is that permission is hereby granted to link Bayonne 
// with  the Pika MonteCarlo libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name Bayonne.  If you copy code from other releases into a copy of
// Bayonne, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to Bayonne, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <bayonne.h>

static char *dirfirst(scriptsymbol_t *sym, char **args)
{
	Dir dir(*(args++));
	char *name;
	char *ext;
	char **arglist;

	while(NULL != (name = dir.getName()))
	{
		ext = strrchr(name, '.');
		if(!ext)
			continue;

		arglist = args;
		while(*arglist)
		{
			if(!stricmp(ext, *arglist))
			{
				strcpy(sym->data, name);
				return NULL;
			}
			++arglist;
		}
	}
	return "no-files";
}	


static char *dircount(scriptsymbol_t *sym, char **args)
{
	Dir dir(*(args++));
	char *name;
	char *ext;
	char **arglist;
	int count = 0;

	while(NULL != (name = dir.getName()))
	{
		ext = strrchr(name, '.');
		if(!ext)
			continue;

		arglist = args;
		while(*arglist)
		{
			if(!stricmp(ext, *arglist))
			{
				++count;
				break;
			}
			++arglist;
		}
	}
	sprintf(sym->data, "%d", count);
	return NULL;
}	
		
static char *dirstat(scriptsymbol_t *sym, char **args)
{
	struct stat ino;
	struct tm *dt;
	sym->data[0] = 0;
	char *fn = *(args++);
	if(!fn)
		return "no-dir";

	if(stat(fn, &ino))
		return "no-dir";

	if(!S_ISDIR(ino.st_mode))
		return "no-dir";
	
	dt = localtime(&ino.st_mtime);
	sprintf(sym->data, "%ld,%04d%02d%02d,%02d:%02d:%02d",
		(long)ino.st_size,
		dt->tm_year + 1900, dt->tm_mon + 1, dt->tm_mday,
		dt->tm_hour, dt->tm_min, dt->tm_sec);

	return NULL;
}

class DirFunctions : public Functions
{
private:
	char *getName(void)
		{return "dir";};

public:
	DirFunctions()
	{
		static FUNCTIONS funs[] = {
			{"dirstat", dirstat},
			{"dircount", dircount},
			{"dirfirst", dirfirst},
			{NULL, NULL}};

		Load(funs);
	};
} mydir;

