
/* Assorted matrix functions written for ELIZC by JPG */
/* Examples: Let M be a 4x4 matrix.
SEL(M,[1,3],[2,4]); gives MATRIX([M12,M14],[M32,M34]).
	SEL is short for SELECT.
ROWS(M,[1,3]); gives MATRIX([M11,M12,M13,M14],[M31,M32,M33,M34]).
COLS(M,[1,3]); gives MATRIX([M11,M13],[M21,M23],[M31,M33],[M41,M43]). */

SEL(M,R,C):=BLOCK([SUBSCRMAP:TRUE],APPLY('MATRIX,EV(M[R,C],EVAL)))$ 
ROWS(M,R):=APPLY('MATRIX,MAKELIST(M[I],I,R))$ 
COLS(M,C):=TRANSPOSE(ROWS(TRANSPOSE(M),C))$ 
