webpackJsonp([11],{

/***/ 151:
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2015 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Page shown to the user to confirm entering
 * a contract.
 */
/**
 * Imports.
 */
const i18n = __webpack_require__(7);
const renderHtml_1 = __webpack_require__(5);
const wxApi = __webpack_require__(2);
const React = __webpack_require__(1);
const ReactDOM = __webpack_require__(3);
const URI = __webpack_require__(6);
const wxApi_1 = __webpack_require__(2);
const Amounts = __webpack_require__(4);
class Details extends React.Component {
    constructor(props) {
        super(props);
        console.log("new Details component created");
        this.state = {
            collapsed: props.collapsed,
        };
        console.log("initial state:", this.state);
    }
    render() {
        if (this.state.collapsed) {
            return (React.createElement("div", null,
                React.createElement("button", { className: "linky", onClick: () => { this.setState({ collapsed: false }); } },
                    React.createElement(i18n.Translate, { wrap: "span" }, "show more details"))));
        }
        else {
            return (React.createElement("div", null,
                React.createElement("button", { className: "linky", onClick: () => this.setState({ collapsed: true }) }, "i18n.str`show fewer details`"),
                React.createElement("div", null,
                    i18n.str `Accepted exchanges:`,
                    React.createElement("ul", null, this.props.contractTerms.exchanges.map((e) => React.createElement("li", null, `${e.url}: ${e.master_pub}`))),
                    i18n.str `Exchanges in the wallet:`,
                    React.createElement("ul", null, (this.props.exchanges || []).map((e) => React.createElement("li", null, `${e.baseUrl}: ${e.masterPublicKey}`))))));
        }
    }
}
class ContractPrompt extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            abortDone: false,
            abortStarted: false,
            alreadyPaid: false,
            checkPayError: undefined,
            confirmPayError: undefined,
            exchanges: undefined,
            holdCheck: false,
            payAttempt: 0,
            payDisabled: true,
            payInProgress: false,
            proposal: undefined,
            proposalId: props.proposalId,
            replaying: false,
            working: false,
        };
    }
    componentWillMount() {
        this.update();
    }
    componentWillUnmount() {
        // FIXME: abort running ops
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.props.resourceUrl) {
                const p = yield wxApi.queryPaymentByFulfillmentUrl(this.props.resourceUrl);
                console.log("query for resource url", this.props.resourceUrl, "result", p);
                if (p && p.finished) {
                    if (p.lastSessionSig === undefined || p.lastSessionSig === this.props.sessionId) {
                        const nextUrl = new URI(p.contractTerms.fulfillment_url);
                        nextUrl.addSearch("order_id", p.contractTerms.order_id);
                        if (p.lastSessionSig) {
                            nextUrl.addSearch("session_sig", p.lastSessionSig);
                        }
                        location.replace(nextUrl.href());
                        return;
                    }
                    else {
                        // We're in a new session
                        this.setState({ replaying: true });
                        // FIXME:  This could also go wrong.  However the payment
                        // was already successful once, so we can just retry and not refund it.
                        const payResult = yield wxApi.submitPay(p.contractTermsHash, this.props.sessionId);
                        console.log("payResult", payResult);
                        location.replace(payResult.nextUrl);
                        return;
                    }
                }
            }
            let proposalId = this.props.proposalId;
            if (proposalId === undefined) {
                if (this.props.contractUrl === undefined) {
                    // Nothing we can do ...
                    return;
                }
                proposalId = yield wxApi.downloadProposal(this.props.contractUrl);
            }
            const proposal = yield wxApi.getProposal(proposalId);
            this.setState({ proposal, proposalId });
            this.checkPayment();
            const exchanges = yield wxApi.getExchanges();
            this.setState({ exchanges });
        });
    }
    checkPayment() {
        return __awaiter(this, void 0, void 0, function* () {
            window.setTimeout(() => this.checkPayment(), 500);
            if (this.state.holdCheck) {
                return;
            }
            const proposalId = this.state.proposalId;
            if (proposalId === undefined) {
                return;
            }
            const payStatus = yield wxApi.checkPay(proposalId);
            if (payStatus.status === "insufficient-balance") {
                const msgInsufficient = i18n.str `You have insufficient funds of the requested currency in your wallet.`;
                // tslint:disable-next-line:max-line-length
                const msgNoMatch = i18n.str `You do not have any funds from an exchange that is accepted by this merchant. None of the exchanges accepted by the merchant is known to your wallet.`;
                if (this.state.exchanges && this.state.proposal) {
                    const acceptedExchangePubs = this.state.proposal.contractTerms.exchanges.map((e) => e.master_pub);
                    const ex = this.state.exchanges.find((e) => acceptedExchangePubs.indexOf(e.masterPublicKey) >= 0);
                    if (ex) {
                        this.setState({ checkPayError: msgInsufficient });
                    }
                    else {
                        this.setState({ checkPayError: msgNoMatch });
                    }
                }
                else {
                    this.setState({ checkPayError: msgInsufficient });
                }
                this.setState({ payDisabled: true });
            }
            else if (payStatus.status === "paid") {
                this.setState({ alreadyPaid: true, payDisabled: false, checkPayError: undefined, payStatus });
            }
            else {
                this.setState({ payDisabled: false, checkPayError: undefined, payStatus });
            }
        });
    }
    doPayment() {
        return __awaiter(this, void 0, void 0, function* () {
            const proposal = this.state.proposal;
            this.setState({ holdCheck: true, payAttempt: this.state.payAttempt + 1 });
            if (!proposal) {
                return;
            }
            const proposalId = proposal.id;
            if (proposalId === undefined) {
                console.error("proposal has no id");
                return;
            }
            console.log("confirmPay with", proposalId, "and", this.props.sessionId);
            let payResult;
            this.setState({ working: true });
            try {
                payResult = yield wxApi.confirmPay(proposalId, this.props.sessionId);
            }
            catch (e) {
                if (!(e instanceof wxApi_1.WalletApiError)) {
                    throw e;
                }
                this.setState({ confirmPayError: e.detail });
                return;
            }
            console.log("payResult", payResult);
            document.location.replace(payResult.nextUrl);
            this.setState({ holdCheck: true });
        });
    }
    abortPayment() {
        return __awaiter(this, void 0, void 0, function* () {
            const proposal = this.state.proposal;
            this.setState({ holdCheck: true, abortStarted: true });
            if (!proposal) {
                return;
            }
            wxApi.abortFailedPayment(proposal.contractTermsHash);
            this.setState({ abortDone: true });
        });
    }
    render() {
        if (this.props.contractUrl === undefined && this.props.proposalId === undefined) {
            return React.createElement("span", null, "Error: either contractUrl or proposalId must be given");
        }
        if (this.state.replaying) {
            return React.createElement("span", null, "Re-submitting existing payment");
        }
        if (this.state.proposalId === undefined) {
            return React.createElement("span", null, "Downloading contract terms");
        }
        if (!this.state.proposal) {
            return React.createElement("span", null, "...");
        }
        const c = this.state.proposal.contractTerms;
        let merchantName;
        if (c.merchant && c.merchant.name) {
            merchantName = React.createElement("strong", null, c.merchant.name);
        }
        else {
            merchantName = React.createElement("strong", null,
                "(pub: ",
                c.merchant_pub,
                ")");
        }
        const amount = React.createElement("strong", null, renderHtml_1.renderAmount(Amounts.parseOrThrow(c.amount)));
        console.log("payStatus", this.state.payStatus);
        let products = null;
        if (c.products.length) {
            products = (React.createElement("div", null,
                React.createElement("span", null, "The following items are included:"),
                React.createElement("ul", null, c.products.map((p, i) => (React.createElement("li", { key: i },
                    p.description,
                    ": ",
                    renderHtml_1.renderAmount(p.price)))))));
        }
        const ConfirmButton = () => (React.createElement("button", { className: "pure-button button-success", disabled: this.state.payDisabled, onClick: () => this.doPayment() }, i18n.str `Confirm payment`));
        const WorkingButton = () => (React.createElement("div", null,
            React.createElement("button", { className: "pure-button button-success", disabled: this.state.payDisabled, onClick: () => this.doPayment() },
                React.createElement("span", null,
                    React.createElement("object", { className: "svg-icon svg-baseline", data: "/img/spinner-bars.svg" }),
                    " "),
                i18n.str `Submitting payment`)));
        const ConfirmPayDialog = () => (React.createElement("div", null,
            this.state.working ? WorkingButton() : ConfirmButton(),
            React.createElement("div", null,
                (this.state.alreadyPaid
                    ? React.createElement("p", { className: "okaybox" }, i18n.str `You already paid for this, clicking "Confirm payment" will not cost money again.`)
                    : React.createElement("p", null)),
                (this.state.checkPayError ? React.createElement("p", { className: "errorbox" }, this.state.checkPayError) : React.createElement("p", null))),
            React.createElement(Details, { exchanges: this.state.exchanges, contractTerms: c, collapsed: !this.state.checkPayError })));
        const PayErrorDialog = () => (React.createElement("div", null,
            React.createElement("p", null,
                "There was an error paying (attempt #",
                this.state.payAttempt,
                "):"),
            React.createElement("pre", null, JSON.stringify(this.state.confirmPayError)),
            this.state.abortStarted
                ? React.createElement("span", null, i18n.str `Aborting payment ...`)
                : this.state.abortDone
                    ? React.createElement("span", null, i18n.str `Payment aborted!`)
                    : React.createElement(React.Fragment, null,
                        React.createElement("button", { className: "pure-button", onClick: () => this.doPayment() }, i18n.str `Retry Payment`),
                        React.createElement("button", { className: "pure-button", onClick: () => this.abortPayment() }, i18n.str `Abort Payment`))));
        return (React.createElement("div", null,
            React.createElement(i18n.Translate, { wrap: "p" },
                "The merchant",
                " ",
                React.createElement("span", null, merchantName),
                " offers you to purchase:"),
            React.createElement("div", { style: { "text-align": "center" } },
                React.createElement("strong", null, c.summary)),
            React.createElement("strong", null),
            products,
            (this.state.payStatus && this.state.payStatus.coinSelection)
                ? React.createElement(i18n.Translate, { wrap: "p" },
                    "The total price is ",
                    React.createElement("span", null,
                        amount,
                        " "),
                    " (plus ",
                    React.createElement("span", null, renderHtml_1.renderAmount(this.state.payStatus.coinSelection.totalFees)),
                    " fees).")
                :
                    React.createElement(i18n.Translate, { wrap: "p" },
                        "The total price is ",
                        React.createElement("span", null, amount),
                        "."),
            this.state.confirmPayError
                ? PayErrorDialog()
                : ConfirmPayDialog()));
    }
}
document.addEventListener("DOMContentLoaded", () => {
    const url = new URI(document.location.href);
    const query = URI.parseQuery(url.query());
    let proposalId;
    try {
        proposalId = JSON.parse(query.proposalId);
    }
    catch (_a) {
        // ignore error
    }
    const sessionId = query.sessionId;
    const contractUrl = query.contractUrl;
    const resourceUrl = query.resourceUrl;
    ReactDOM.render(React.createElement(ContractPrompt, Object.assign({}, { proposalId, contractUrl, sessionId, resourceUrl })), document.getElementById("contract"));
});


/***/ })

},[151]);
//# sourceMappingURL=confirm-contract-bundle.js.map