;;; -*-  Mode: Lisp; Package: Maxima; Syntax: Common-Lisp; Base: 10 -*- ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;     The data in this file contains enhancments.                    ;;;;;
;;;                                                                    ;;;;;
;;;  Copyright (c) 1984,1987 by William Schelter,University of Texas   ;;;;;
;;;     All rights reserved                                            ;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;     (c) Copyright 1982 Massachusetts Institute of Technology         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "MAXIMA")
(macsyma-module nisimp)

;;;programs for the LET LETSIMP LETRULES and REMLET commands
;;;these programs use the names LETSIMPTREE and LETRULES on the 
;;;property list of atoms
;;;except for the top level programs all program names have the prefix NIS

(DECLARE-TOP (*EXPR $RATEXPAND)
	 (*LEXPR $DISP)
	 (SPECIAL NISTREE NISRULES NISFLAG $RATEXPAND VARLIST $RATFAC)) 

(DEFMVAR $LETVARSIMP NIL)

(DEFMVAR $LETRAT NIL) 

(DEFMVAR $DEFAULT_LET_RULE_PACKAGE '$DEFAULT_LET_RULE_PACKAGE
  "The name of the default rule package used by LET and LETSIMP")
(putprop '$default_let_rule_package 'let-rule-setter 'assign)

(DEFMVAR $CURRENT_LET_RULE_PACKAGE '$DEFAULT_LET_RULE_PACKAGE
  "The name of the current rule package used by LET and LETSIMP")
(putprop '$current_let_rule_package 'let-rule-setter 'assign)

(DEFMVAR $LET_RULE_PACKAGES '((MLIST) $DEFAULT_LET_RULE_PACKAGE)
  "The names of the various let rule simplification packages")
(putprop '$let_rule_packages 'let-rule-setter 'assign)

(SETQ NISRULES NIL NISTREE NIL) 

(defun let-rule-setter (var val)
  (cond ((eq var '$default_let_rule_package)
	 (merror "~%Attempt to change DEFAULT_LET_RULE_PACKAGE~%"))
	((and (eq var '$current_let_rule_package)
	      (not (memalike val (cdr $let_rule_packages))))
	 (merror "~%~M is not a rule package~%" val))
	((eq var '$let_rule_packages)
	 (merror "~%Use LET to add let rule packages~%"))))
	 
(DEFMSPEC $LET (L) (SETQ L (CDR L))
  (IF (NULL (CDR L)) (WNA-ERR '$LET))
  ;;LET([PATTERN,REPL,PRED,ARG1,...,ARGN],NAME)
       (PROG (PATTERN PAT REPLACEMENT TREENAME TEXT $RATFAC) 
  ;;LET(PATTERN,REPL,PRED,ARG1,...,ARGN)
	     (COND ((ATOM (CAR L))
		    (SETQ TREENAME $CURRENT_LET_RULE_PACKAGE))
		   ((EQ 'MLIST (CAAAR L))
		    (SETQ TREENAME (CADR L))
		    (IF (NOT (SYMBOLP TREENAME))
			(IMPROPER-ARG-ERR TREENAME '$LET))
		    (SETQ L (CDAR L)))
		   (T (SETQ TREENAME $CURRENT_LET_RULE_PACKAGE)))
	 (LET ((NISTREE (MGET TREENAME 'LETSIMPTREE))
	       (NISRULES (MGET TREENAME 'LETRULES)))
	   (SETQ PAT (MEVAL (CAR L)))
	   (SETQ REPLACEMENT (CDR L))
	   (SETQ PATTERN (COND ((ATOM PAT) (LIST PAT))
			       ((EQ (CAAR PAT) 'MTIMES)
				(CDR PAT))
			       (T (LIST PAT))))
	   (SETQ NISTREE (NISLET NISTREE PATTERN REPLACEMENT))
	   (COND (TREENAME (MPUTPROP TREENAME
				     NISTREE
				     'LETSIMPTREE)
			   (ADD2LNC TREENAME $LET_RULE_packages)))
	   (NONSYMCHK (CADDR L) '$LET)
	   (SETQ TEXT
		 (APPEND (LIST '(MTEXT) PAT '| --> | )
			 (COND ((CDDR L)
				(LIST (CADR L)
				      '| WHERE | 
				      (CONS (LIST (CADDR L))
					    (CDDDR L))))
			       (T REPLACEMENT))))
	   (SETQ NISRULES (APPEND (LIST TEXT) NISRULES))
	   (COND (TREENAME (MPUTPROP TREENAME
				     NISRULES
				     'LETRULES)))
	   (RETURN TEXT))))

(DEFUN NISLET (TREE LIST FUNCTION) 
       (PROG (PERMLIST) 
	     (SETQ PERMLIST (NISPERMUTATIONS LIST))
	STEP (COND ((EQ NIL PERMLIST) (RETURN TREE)))
	     (SETQ TREE (NISTREEBUILDER TREE (CAR PERMLIST) FUNCTION))
	     (SETQ PERMLIST (CDR PERMLIST))
	     (GO STEP))) 

(DEFUN NISPERMUTATIONS (LLIST) 
       (COND
	((NULL (CDR LLIST)) (LIST LLIST))
	(T
	 (PROG (PERMLIST A) 
	  STEP (SETQ 
		PERMLIST
		(APPEND
		 (NISADDON (CAR LLIST)
			   (NISPERMUTATIONS (APPEND A (CDR LLIST))))
		 PERMLIST))
	       (IF (NULL (CDR LLIST)) (RETURN PERMLIST))
	       (SETQ A (CONS (CAR LLIST) A))
	       (SETQ LLIST (CDR LLIST))
	       (GO STEP))))) 
(DEFUN NISADDON (X LLIST) 
  (IF LLIST (CONS (CONS X (CAR LLIST)) (NISADDON X (CDR LLIST))))) 

(DEFUN NISTREEBUILDER (TREE PERM FUNCTION) 
       (COND ((NULL PERM) (CONS (LIST FUNCTION) TREE))
	     ((NULL TREE)
	      (LIST (CONS (CAR PERM)
			  (NISTREEBUILDER NIL (CDR PERM) FUNCTION))))
	     ((EQUAL (CAR PERM) (CAAR TREE))
	      (NISSWCAR TREE
			(NISSWCDR (CAR TREE)
				  (NISTREEBUILDER (CDAR TREE)
						  (CDR PERM)
						  FUNCTION))))
	     (T (NISSWCDR TREE
			  (NISTREEBUILDER (CDR TREE)
					  PERM
					  FUNCTION))))) 

(DEFUN NISSWCAR (X Y) (CONS Y (CDR X))) 

(DEFUN NISSWCDR (X Y) (CONS (CAR X) Y)) 

(DEFMSPEC $REMLET (X) (SETQ X (CDR X))
       ;; REMLET(PROD,NAME) REMLET(PROD) REMLET() REMLET(FALSE,NAME)
  (PROG (PATTERN TEXT TREENAME)
	(COND ((CDDR X) (WNA-ERR '$REMLET))
	      ((NULL (CDR X)) (SETQ TREENAME $CURRENT_LET_RULE_PACKAGE))
	      (T (SETQ TREENAME (CADR X))
		 (IF (NOT (SYMBOLP TREENAME))
		     (IMPROPER-ARG-ERR TREENAME '$REMLET))))
	(SETQ PATTERN (MEVAL (CAR X)))
	(WHEN (OR (NOT PATTERN) (EQ '$ALL PATTERN))
	  (SETQ NISRULES NIL NISTREE NIL)
	  (IF (NOT (EQ TREENAME '$DEFAULT_LET_RULE_PACKAGE))
	      (DELQ TREENAME $LET_RULE_PACKAGES 1))
	  (GO A))
	(SETQ NISTREE (MGET TREENAME 'LETSIMPTREE))
	(IF (SETQ TEXT (NISREMLET PATTERN)) (RETURN TEXT))
	(IF NISTREE
	    (SETQ NISRULES
		  (NISTREELISTER (MGET TREENAME 'LETRULES) PATTERN))
	    (SETQ NISRULES NIL))
   A    (MPUTPROP TREENAME NISTREE 'LETSIMPTREE)
	(MPUTPROP TREENAME NISRULES 'LETRULES)
	(RETURN '$DONE)))

(DEFUN NISTREELISTER (LLIST PATTERN) 
  (PROG (X) 
   A    (IF (ALIKE1 PATTERN (CADAR LLIST)) (RETURN (APPEND X (CDR LLIST))))
	(SETQ X (APPEND X (LIST (CAR LLIST))) LLIST (CDR LLIST))
	(GO A))) 

(DEFUN NISREMLET (PAT) 
  (PROG (LLIST PERMLIST X) 
	(SETQ LLIST (IF (MTIMESP PAT) (CDR PAT) (NCONS PAT)))
	(SETQ NISFLAG T X NISTREE)
	(SETQ PERMLIST (NISPERMUTATIONS LLIST))
   STEP (WHEN (NULL PERMLIST) (SETQ NISTREE X) (RETURN NIL))
	(SETQ X (NISTREETRIMMER (CAR PERMLIST) X))
	(IF (NULL NISFLAG) (MERROR "~M not found - REMLET" PAT))
	(SETQ PERMLIST (CDR PERMLIST))
	(GO STEP))) 

(DEFUN NISTREETRIMMER (PERM TREE) 
  (COND ((NULL PERM)
	 (COND ((NULL TREE) (SETQ NISFLAG NIL))
	       ((NULL (CDAR TREE))
		(SETQ NISFLAG (CAAR TREE)) (CDR TREE))
	       (T (NISSWCDR TREE (NISTREETRIMMER NIL (CDR TREE))))))
	((NULL TREE) (SETQ NISFLAG NIL))
	((EQUAL (CAR PERM) (CAAR TREE))
	 (PROG (X) 
	       (SETQ X (NISTREETRIMMER (CDR PERM) (CDAR TREE)))
	       (IF (NULL X) (RETURN (CDR TREE)))
	       (RETURN (NISSWCAR TREE (NISSWCDR (CAR TREE) X)))))
	(T (NISSWCDR TREE (NISTREETRIMMER PERM (CDR TREE)))))) 

(DEFMSPEC $LETRULES (NAME) (SETQ NAME (CDR NAME))  ;LETRULES(NAME)
  (LET ((TREENAME (IF NAME (CAR NAME) $CURRENT_LET_RULE_PACKAGE)))
    (IF (NOT (SYMBOLP TREENAME)) (IMPROPER-ARG-ERR TREENAME '$LETRULES))
    (SETQ NISTREE (MGET TREENAME 'LETSIMPTREE)
	  NISRULES (MGET TREENAME 'LETRULES))
    (APPLY #'$DISP NISRULES)))

(DEFMSPEC $LETSIMP (X) (SETQ X (CDR X)) ; LETSIMP(EXPR,TREE1,...,TREEN)
 (LET ((VARLIST VARLIST) (GENVAR GENVAR))
  (PROG (EXPR SW $RATFAC) 
    (SETQ EXPR (MEVAL (CAR X)))
    (COND ((ATOM EXPR))
	  ((EQ (CAAR EXPR) 'MRAT)
	   (COND ((MEMQ 'TRUNC (CDAR EXPR)) (SETQ EXPR ($TAYTORAT EXPR))))
	   (SETQ SW T))
	  (T (SETQ EXPR (RATF EXPR))))
    (COND ((NULL (CDR X))
	   (SETQ NISTREE (MGET $CURRENT_LET_RULE_PACKAGE 'LETSIMPTREE))
	   (SETQ EXPR (NISLETSIMP EXPR))
	   (RETURN (IF SW (RATF EXPR) EXPR))))
   A  
    (SETQ X (CDR X))
    (IF (NOT (SYMBOLP (CAR X))) (IMPROPER-ARG-ERR (CAR X) '$LETSIMP))
    (SETQ NISTREE (MGET (CAR X) 'LETSIMPTREE))
    (IF NISTREE (SETQ EXPR (NISLETSIMP EXPR)))
    (IF (CDR X) (GO A) (RETURN (IF SW (RATF EXPR) EXPR))))))

(DEFUN NISLETSIMP (E) 
  (LET (X)
    (COND ((MNUMP E) E)
	  ((OR (AND (ATOM E) (SETQ X (NCONS E)))
	       (AND (EQ (CAAR E) 'MTIMES) (SETQ X (CDR E))))
	   (SETQ X (NISNEWLIST X))
	   (IF X (NISLETSIMP ($RATEXPAND (CONS '(MTIMES) X))) E))
	  ((MEMQ (CAAR E) '(MPLUS MEQUAL MLIST $MATRIX))
	   (CONS (IF (EQ (CAAR E) 'MPLUS) '(MPLUS) (CAR E))
		 (MAPCAR #'NISLETSIMP (CDR E))))
	  ((OR (EQ (CAAR E) 'MRAT) 
	       (AND (EQ (CAAR E) 'MQUOTIENT) (SETQ E (RATF E))))
	   (NISLETSIMPRAT E))
	  (T ;; A kernel (= product of 1 element)
	     (SETQ X (NISNEWLIST (NCONS E)))
	     (IF X (NISLETSIMP ($RATEXPAND (CONS '(MTIMES) X))) E)))))

(DEFUN NISLETSIMPRAT (E)
  (LET ((NUM (CADR E)) (DENOM (CDDR E)) $RATEXPAND)
   (IF $LETVARSIMP (SETQ VARLIST (MAPCAR #'NISLETSIMP VARLIST)))
   (LET (($RATEXPAND T))
     (SETQ NUM (NISLETSIMP (PDIS NUM)) DENOM (NISLETSIMP (PDIS DENOM))))
   (SETQ E (LIST '(MQUOTIENT) NUM DENOM))
   (IF $LETRAT (NISLETSIMP ($RATEXPAND E)) E)))

(DEFUN NISNEWLIST (LLIST)
  (LET ((X (NISSEARCH LLIST NISTREE NIL))) (IF X (NISREPLACE LLIST X))))

(DEFUN NISSEARCH (X Y Z) 
       (COND ((NULL Y) NIL)
	     ((NISINNERNULL Y) (NISFIX (NISINNERNULL Y) Z))
	     ((NULL X) NIL)
	     (T (PROG (XX YY PATH BIND) 
		      (SETQ YY Y)
		 A    (SETQ XX X)
		 B    (COND ((AND (SETQ BIND (NISMATCH (CAR XX)
						       (CAAR YY)
						       Z))
				  (SETQ PATH
					(NISSEARCH (CDR XX)
						   (CDAR YY)
						   (CDR BIND))))
			     (RETURN (CONS (CAR BIND) PATH))))
		      (SETQ XX (CDR XX))
		      (COND (XX (GO B)))
		      (SETQ YY (CDR YY))
		      (COND ((NULL YY) (RETURN NIL)))
		      (GO A))))) 

(DEFUN NISINNERNULL (X) 
       (COND ((NULL X) NIL)
	     ((NULL (CDAR X)) (CAAR X))
	     (T (NISINNERNULL (CDR X))))) 

(DEFUN NISFIX (FUNPERD ARGASSLIST) 
  (PROG (FUNCTION ARGS BINDINGS PERD FLAG) 
	(IF (NOT ARGASSLIST) (RETURN (CAR FUNPERD)))
	(SETQ ARGASSLIST (NISNUMBERPICKER ARGASSLIST))
	(SETQ ARGS (MAPLIST 'CAAR ARGASSLIST))
	(SETQ BINDINGS (MAPLIST 'CDAR ARGASSLIST))
	(MBINDING (ARGS BINDINGS)
	      (SETQ FUNCTION (CAR FUNPERD))
	      (IF (SETQ PERD (CDR FUNPERD))
		  (IF (NOT (MEVAL PERD)) (SETQ FLAG T)))
	      (IF (NULL FLAG) (SETQ FUNCTION (MEVAL FUNCTION))))
	(RETURN (IF FLAG NIL (LIST FUNCTION)))))

(DEFUN NISNUMBERPICKER (X) 
       (COND ((NULL X) NIL)
	     ((NOT (SYMBOLP (CAAR X))) (NISNUMBERPICKER (CDR X)))
	     (T (NISSWCDR X (NISNUMBERPICKER (CDR X)))))) 

(DEFUN NISMATCH (A B C) 
       (PROG (X Y NEWEXPT) 
	     (SETQ X (NISEXTRACT A))
	     (SETQ Y (NISEXTRACT B))
	     (COND
	      ((CADR Y)
	       (COND ((AND (EQual (CAR X) (CAR Y))
			   (SETQ NEWEXPT (NISEXPOCHECK (CDDR X)
						       (CDDR Y)
						       C))
			   (SETQ C (NISARGSCHECKER (CADR X)
						   (CADR Y)
						   C)))
		      (COND ((EQUAL '(RAT) (CAR NEWEXPT))
			     (RETURN (CONS (CONS A (NISBUILD X NEWEXPT))
					   C)))
			    (T (RETURN (CONS (CONS A '(DUMMY 0 (0 0)))
					     NEWEXPT)))))
		     (T (RETURN NIL)))))
	     (COND ((AND (SETQ C (NISARGMATCH (NISKERNEL A) (CAR Y) C))
			 (SETQ NEWEXPT (NISEXPOCHECK (CDDR X)
						     (CDDR Y)
						     C)))
		    (COND ((EQUAL '(RAT) (CAR NEWEXPT))
			   (RETURN (CONS (CONS A (NISBUILD X NEWEXPT))
					 C)))
			  (T (RETURN (CONS (CONS A '(DUMMY 0 (0 0)))
					   NEWEXPT))))))
	     (RETURN NIL))) 

(DEFUN NISKERNEL (A) (IF (MEXPTP A) (CADR A) A))

(DEFUN NISEXTRACT (X)
       (COND ((OR (ATOM X) (EQ (CAAR X) 'RAT))
	      (CONS X (CONS NIL 1)))
	     ((EQ 'MEXPT (CAAR X))
	      (COND ((ATOM (CADR X))
		     (CONS (CADR X) (CONS NIL (CADDR X))))
		    (T (CONS (if (memq 'array (cdaadr x))
				 (list (caaadr x) 'array)
				 (CAAADR X))
			     (CONS (CDADR X) (CADDR X))))))
	     (T (CONS (if (memq 'array (cdar x)) (list (caar x) 'array)
						 (CAAR X))
			  (CONS (CDR X) 1))))) 

(DEFUN NISARGSCHECKER (LISTARGS TREEARGS ARGASSLIST) 
       (PROG (C) 
	     (COND ((AND LISTARGS TREEARGS) (GO CHECK))
		   ((OR LISTARGS TREEARGS) (RETURN NIL))
		   (T (RETURN ARGASSLIST)))
	CHECK(SETQ C (NISARGMATCH (CAR LISTARGS)
				  (CAR TREEARGS)
				  ARGASSLIST))
	     (COND (C (RETURN (NISARGSCHECKER (CDR LISTARGS)
					      (CDR TREEARGS)
					      C)))
		   (T (RETURN NIL))))) 

(DEFUN NISEXPOCHECK (LISTPOWER TREEPOWER ARGASSLIST) 
       (PROG (P Q R S A B XX) 
	     (COND ((ATOM TREEPOWER)
		    (COND ((NUMBERP TREEPOWER)
			   (PROG2 (SETQ R TREEPOWER S 1) (GO MATH)))
			  (T (RETURN (NISARGMATCH LISTPOWER
						  TREEPOWER
						  ARGASSLIST))))))
	     (SETQ R (CADR TREEPOWER) S (CADDR TREEPOWER))
	     (IF (NOT (NUMBERP S)) (RETURN NIL))
	MATH (COND ((NUMBERP LISTPOWER) (SETQ P LISTPOWER Q 1))
		   ((ATOM LISTPOWER) (RETURN NIL))
		   ((EQ 'RAT (CAAR LISTPOWER))
		    (SETQ P (CADR LISTPOWER) Q (CADDR LISTPOWER)))
		   (T (RETURN NIL)))
	     (SETQ XX (TIMES (TIMES Q S)
			     (DIFFERENCE (TIMES P S) (TIMES Q R))))
	     (SETQ A (LESSP (TIMES R S) 0))
	     (SETQ B (LESSP XX 0))
	     (COND ((OR (NOT (OR A B)) (AND A (OR B (EQUAL 0 XX))))
		    (RETURN (LIST '(RAT) XX (TIMES Q S)))))
	     (RETURN NIL))) 

(DEFUN NISARGMATCH (X Y C) 
       (PROG (W) 
	     (SETQ W C)
	UP   (IF (NULL W) (GO DOWN))
	     (COND ((EQ (CAAR W) Y)
		    (COND ((ALIKE1 (CDAR W) X) (RETURN C))
			  (T (RETURN NIL)))))
	     (SETQ W (CDR W))
	     (GO UP)
	DOWN (SETQ W (MGET Y 'MATCHDECLARE))
	     (COND ((NULL W) (IF (EQUAL X Y) (GO OUT) (RETURN NIL)))
		   ((MEMQ (CAR W) '($TRUE T)) (GO OUT))
		   ((AND (ATOM (CAR W))
			 (MEVAL (CONS (NCONS (CAR W))
				      (APPEND (CDR W) (LIST X)))))
		    (GO OUT))
		   ((AND (NOT (ATOM (CAR W)))
			 (NOT (ATOM (CAAR W)))
			 (ATOM (CAAAR W))
			 (MEVAL (APPEND (CAR W) (LIST X))))
		    (GO OUT))
		   (T (RETURN NIL)))
	OUT  (RETURN (CONS (CONS Y X) C)))) 

(DEFUN NISBUILD (X NEWEXPT) 
       (LIST '(MEXPT)
	     (IF (CADR X)
		 (CONS (IF (symbolp (car x)) (NCONS (CAR X)) (car x))
			   (CADR X))
		 (CAR X))
	     NEWEXPT)) 

(DEFUN NISREPLACE (LLIST ASSLIST) 
       (COND ((EQ (CDR ASSLIST) NIL) (CONS (CAR ASSLIST) LLIST))
	     ((EQUAL (CAR LLIST) (CAAR ASSLIST))
	      (COND ((EQUAL 0 (CADAR (CDDDAR ASSLIST)))
		     (NISREPLACE (CDR LLIST) (CDR ASSLIST)))
		    (T (CONS (CDAR ASSLIST)
			     (NISREPLACE (CDR LLIST) (CDR ASSLIST))))))
	     (T (CONS (CAR LLIST) (NISREPLACE (CDR LLIST) ASSLIST))))) 

