/* some statistics generation
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

#ifdef NeXT
#include <stdlib.h>
#include <bsd/curses.h>
#else
#include <malloc.h>
double atof();
#include <curses.h>
#endif

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <signal.h>
#include <math.h>
#include <string.h>

#include "capaCommon.h"


main (int argc, char  **argv) 
{

  T_student *head_p, *c_p;
  T_header   a_header;
  T_entry    a_entry;
  int        student_cnt, set_idx;
  int        sec, set_scores, set_valids;
  char      *answers_p, wgt[128], pcr[128];
  int        MaxSec;
  int        MaxSet=9;
  int        total_scores, total_set_valids;
  int        count;
  int        *cnt_arry;
   int        inputNotOK=1;
   char       path[FILE_NAME_LENGTH];
   char       filename[FILE_NAME_LENGTH];
   /* char       classlist[FILE_NAME_LENGTH];
   char       studentclass[FILE_NAME_LENGTH]; */
   char       *classlist;
   char       *studentclass;
   char       *progname;

   if(argc>1) {
     sec = atol(argv[2]);
   } else {
     sec =1;
   }

   while ( inputNotOK ) {
       puts("Enter the ABSOLUTE path of class");
       scanf("%s", path);
       if( access(path, F_OK) == -1 ) {
       } else {
           sprintf(filename,"%s/records",path);
           if( access(filename, F_OK) == -1 ) {
            puts("There isn't a records dir in this CLASS directory");
            puts("Please Specify another calss");
          } else {
            inputNotOK = 0;
          }
       }
    }

    chdir(path);


   for (sec=1;sec<30; sec++){
       if ((count=capa_get_section(&head_p,sec))>0)
          MaxSec=sec;
   }

   for (sec=1;sec<MaxSec;sec++){
       student_cnt = capa_sorted_section(&head_p, sec, 2);
       printf("Section #%d                          Set     ",sec); 
       for (set_idx=1; set_idx<MaxSet; set_idx++) {
           printf(" %2d ",set_idx);
       }
       printf("  Total\n");
       for (c_p=head_p ; c_p ; c_p=c_p->s_next){
           total_scores=0;
           total_set_valids=0;
           printf("%s  (%s)",c_p->s_nm,c_p->s_sn);
           for (set_idx=1; set_idx<MaxSet; set_idx++) {
               set_scores = capa_get_score(c_p->s_sn,set_idx,&set_valids,&answers_p);
               if (set_scores == -1) {   /* never login to do assignments */
                  printf("   -",set_valids);
                  total_set_valids=total_set_valids+set_valids;
               } else {
                  printf("  %2d",set_scores,set_valids);
                  total_scores=total_scores+set_scores;
                  total_set_valids=total_set_valids+set_valids;
                 }
               capa_mfree(answers_p);
           }
           printf("  %3d/%3d \n",total_scores,total_set_valids);
       }

       printf("Total students = %d\n\n\n",student_cnt);
       free_students(head_p);
   }

}

