; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "MIT-GNU Scheme"
!define PRODUCT_VERSION "9.2"
!define PRODUCT_PUBLISHER "GNU Project"
!define PRODUCT_WEB_SITE "http://www.gnu.org/software/mit-scheme/"
!define PRODUCT_DIR_ROOT_KEY "HKLM"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\scheme.exe"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_STARTMENU_REGVAL "NSIS:StartMenuDir"

SetCompressor lzma

!define MIT_SCHEME_ROOT "$%home%\mit-scheme-${PRODUCT_VERSION}"
!define MIT_SCHEME_SRC_ROOT "${MIT_SCHEME_ROOT}\src"
;!define MIT_SCHEME_DOC_ROOT "${MIT_SCHEME_ROOT}\doc"
!define MIT_SCHEME_BIN_DIR "$INSTDIR\bin"
!define MIT_SCHEME_LIB_DIR "$INSTDIR\lib"
!define MIT_SCHEME_DOC_DIR "$INSTDIR\doc"
!define MIT_SCHEME_EXE_NAME "mit-scheme.exe"
!define MIT_SCHEME_EXE "${MIT_SCHEME_BIN_DIR}\${MIT_SCHEME_EXE_NAME}"
!define MIT_SCHEME_OPTIONS "--library $\"${MIT_SCHEME_LIB_DIR}$\" --edit"

!macro mit_scheme_bci_install dir_name
  SetOutPath "${MIT_SCHEME_LIB_DIR}\${dir_name}"
  File "${MIT_SCHEME_SRC_ROOT}\${dir_name}\*.bci"
!macroend

!macro mit_scheme_bci_uninstall dir_name
  Delete "${MIT_SCHEME_LIB_DIR}\${dir_name}\*.bci"
  RMDir "${MIT_SCHEME_LIB_DIR}\${dir_name}"
!macroend

!macro mit_scheme_aux_install dir_name
  !insertmacro mit_scheme_bci_install "${dir_name}"
  File "${MIT_SCHEME_SRC_ROOT}\${dir_name}\*.com"
  File "${MIT_SCHEME_SRC_ROOT}\${dir_name}\*-w32.pkd"
  File /nonfatal "${MIT_SCHEME_SRC_ROOT}\${dir_name}\load.scm"
!macroend

!macro mit_scheme_aux_uninstall dir_name
  Delete "${MIT_SCHEME_LIB_DIR}\${dir_name}\load.scm"
  Delete "${MIT_SCHEME_LIB_DIR}\${dir_name}\*-w32.pkd"
  Delete "${MIT_SCHEME_LIB_DIR}\${dir_name}\*.com"
  !insertmacro mit_scheme_bci_uninstall "${dir_name}"
!macroend

!macro mit_scheme_option_install dir_name root_name
  File "${MIT_SCHEME_SRC_ROOT}\${dir_name}\${root_name}.com"
!macroend

; **************** MUI Begin ****************

!include "MUI2.nsh"
!define MUI_ABORTWARNING
!define MUI_UNABORTWARNING

; Installer pages
!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_LICENSE "${MIT_SCHEME_SRC_ROOT}\copying"
!insertmacro MUI_PAGE_DIRECTORY
; Start menu page
var ICONS_GROUP
!define MUI_STARTMENUPAGE_DEFAULTFOLDER "MIT-GNU Scheme"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_WELCOME
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_UNPAGE_FINISH

!insertmacro MUI_LANGUAGE "English"

; **************** MUI End ****************

Name "MIT/GNU Scheme"
OutFile "mit-scheme-${PRODUCT_VERSION}-i386-win32.exe"
InstallDir "$PROGRAMFILES\MIT-GNU Scheme"
InstallDirRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" \
  "InstallLocation"
ShowInstDetails hide
ShowUnInstDetails hide

Section "MainSection" SEC01
  SetOverwrite try
  SetShellVarContext all

  SetOutPath "${MIT_SCHEME_BIN_DIR}"
  File "/oname=${MIT_SCHEME_EXE_NAME}" \
    "${MIT_SCHEME_SRC_ROOT}\microcode\scheme.exe"
  File "${MIT_SCHEME_SRC_ROOT}\win32\dibutils\dibutils.dll"

  SetOutPath "${MIT_SCHEME_LIB_DIR}"
  File "${MIT_SCHEME_SRC_ROOT}\lib\all.com"
  File "${MIT_SCHEME_SRC_ROOT}\etc\optiondb.scm"

  !insertmacro mit_scheme_bci_install "runtime"
  !insertmacro mit_scheme_option_install "runtime" "chrsyn"
  !insertmacro mit_scheme_option_install "runtime" "cpress"
  !insertmacro mit_scheme_option_install "runtime" "format"
  !insertmacro mit_scheme_option_install "runtime" "mime-codec"
  !insertmacro mit_scheme_option_install "runtime" "numint"
  !insertmacro mit_scheme_option_install "runtime" "optiondb"
  !insertmacro mit_scheme_option_install "runtime" "ordvec"
  !insertmacro mit_scheme_option_install "runtime" "process"
  !insertmacro mit_scheme_option_install "runtime" "rbtree"
  !insertmacro mit_scheme_option_install "runtime" "regexp"
  !insertmacro mit_scheme_option_install "runtime" "rexp"
  !insertmacro mit_scheme_option_install "runtime" "rgxcmp"
  !insertmacro mit_scheme_option_install "runtime" "syncproc"
  !insertmacro mit_scheme_option_install "runtime" "wttree"
  !insertmacro mit_scheme_option_install "runtime" "ystep"

  !insertmacro mit_scheme_bci_install "edwin"
  !insertmacro mit_scheme_option_install "edwin" "artdebug"
  !insertmacro mit_scheme_option_install "edwin" "debian-changelog"
  !insertmacro mit_scheme_option_install "edwin" "eystep"
  !insertmacro mit_scheme_option_install "edwin" "lisppaste"
  !insertmacro mit_scheme_option_install "edwin" "manual"
  !insertmacro mit_scheme_option_install "edwin" "midas"
  !insertmacro mit_scheme_option_install "edwin" "nntp"
  !insertmacro mit_scheme_option_install "edwin" "paredit"
  !insertmacro mit_scheme_option_install "edwin" "pasmod"
  !insertmacro mit_scheme_option_install "edwin" "print"
  !insertmacro mit_scheme_option_install "edwin" "pwedit"
  !insertmacro mit_scheme_option_install "edwin" "pwparse"
  !insertmacro mit_scheme_option_install "edwin" "snr"
  !insertmacro mit_scheme_option_install "edwin" "sort"
  !insertmacro mit_scheme_option_install "edwin" "techinfo"
  !insertmacro mit_scheme_option_install "edwin" "telnet"
  !insertmacro mit_scheme_option_install "edwin" "tximod"
  !insertmacro mit_scheme_option_install "edwin" "verilog"
  !insertmacro mit_scheme_option_install "edwin" "vhdl"
  !insertmacro mit_scheme_option_install "edwin" "webster"
  File "${MIT_SCHEME_SRC_ROOT}\etc\tutorial"
  !ifdef MIT_SCHEME_DOC_ROOT
    File "${MIT_SCHEME_DOC_ROOT}\info\*.*"
  !endif

  !ifdef MIT_SCHEME_DOC_ROOT
    SetOutPath "${MIT_SCHEME_DOC_DIR}"
    File "${MIT_SCHEME_DOC_ROOT}\htdoc\index.html"
    SetOutPath "${MIT_SCHEME_DOC_DIR}\mit-scheme-imail"
    File "${MIT_SCHEME_DOC_ROOT}\htdoc\mit-scheme-imail\*.*"
    SetOutPath "${MIT_SCHEME_DOC_DIR}\mit-scheme-ref"
    File "${MIT_SCHEME_DOC_ROOT}\htdoc\mit-scheme-ref\*.*"
    SetOutPath "${MIT_SCHEME_DOC_DIR}\mit-scheme-sos"
    File "${MIT_SCHEME_DOC_ROOT}\htdoc\mit-scheme-sos\*.*"
    SetOutPath "${MIT_SCHEME_DOC_DIR}\mit-scheme-user"
    File "${MIT_SCHEME_DOC_ROOT}\htdoc\mit-scheme-user\*.*"
  !endif

  !insertmacro mit_scheme_aux_install "cref"
  !insertmacro mit_scheme_aux_install "imail"
  !insertmacro mit_scheme_aux_install "sf"
  !insertmacro mit_scheme_aux_install "sos"
  !insertmacro mit_scheme_aux_install "ssp"
  !insertmacro mit_scheme_aux_install "star-parser"
  !insertmacro mit_scheme_aux_install "xml"

  !insertmacro mit_scheme_bci_install "compiler\back"
  !insertmacro mit_scheme_bci_install "compiler\base"
  !insertmacro mit_scheme_bci_install "compiler\fggen"
  !insertmacro mit_scheme_bci_install "compiler\fgopt"
  !insertmacro mit_scheme_bci_install "compiler\machines\i386"
  !insertmacro mit_scheme_bci_install "compiler\rtlbase"
  !insertmacro mit_scheme_bci_install "compiler\rtlgen"
  !insertmacro mit_scheme_bci_install "compiler\rtlopt"

  ; Shortcuts
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  SetOutPath $INSTDIR
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\MIT-GNU Scheme.lnk" \
    "${MIT_SCHEME_EXE}" "${MIT_SCHEME_OPTIONS}" \
    "${MIT_SCHEME_EXE}" 3
  !ifdef MIT_SCHEME_DOC_ROOT
    CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Documentation.lnk" \
      "${MIT_SCHEME_DOC_DIR}\index.html"
  !endif
  CreateShortCut "$DESKTOP\MIT-GNU Scheme.lnk" \
    "${MIT_SCHEME_EXE}" "${MIT_SCHEME_OPTIONS}" \
    "${MIT_SCHEME_EXE}" 3
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -AdditionalIcons
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" \
    "${PRODUCT_WEB_SITE}"
  SetOutPath $INSTDIR
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Website.lnk" \
    "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk" \
    "$INSTDIR\uninst.exe"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_DIR_ROOT_KEY} "${PRODUCT_DIR_REGKEY}" \
    "" "${MIT_SCHEME_EXE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" \
    "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" \
    "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" \
    "DisplayIcon" "${MIT_SCHEME_EXE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" \
    "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" \
    "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" \
    "Publisher" "${PRODUCT_PUBLISHER}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" \
    "InstallLocation" "$INSTDIR"
SectionEnd

Section Uninstall
  SetShellVarContext all

  !insertmacro MUI_STARTMENU_GETFOLDER "Application" $ICONS_GROUP
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"

  !insertmacro mit_scheme_bci_uninstall "compiler\rtlopt"
  !insertmacro mit_scheme_bci_uninstall "compiler\rtlgen"
  !insertmacro mit_scheme_bci_uninstall "compiler\rtlbase"
  !insertmacro mit_scheme_bci_uninstall "compiler\machines\i386"
  !insertmacro mit_scheme_bci_uninstall "compiler\fgopt"
  !insertmacro mit_scheme_bci_uninstall "compiler\fggen"
  !insertmacro mit_scheme_bci_uninstall "compiler\base"
  !insertmacro mit_scheme_bci_uninstall "compiler\back"
  RmDir "${MIT_SCHEME_LIB_DIR}\compiler\machines"
  RmDir "${MIT_SCHEME_LIB_DIR}\compiler"

  !insertmacro mit_scheme_aux_uninstall "xml"
  !insertmacro mit_scheme_aux_uninstall "star-parser"
  !insertmacro mit_scheme_aux_uninstall "ssp"
  !insertmacro mit_scheme_aux_uninstall "sos"
  !insertmacro mit_scheme_aux_uninstall "sf"
  !insertmacro mit_scheme_aux_uninstall "imail"
  !insertmacro mit_scheme_aux_uninstall "cref"

  Delete "${MIT_SCHEME_DOC_DIR}\mit-scheme-user\*.*"
  RMDir "${MIT_SCHEME_DOC_DIR}\mit-scheme-user"
  Delete "${MIT_SCHEME_DOC_DIR}\mit-scheme-sos\*.*"
  RMDir "${MIT_SCHEME_DOC_DIR}\mit-scheme-sos"
  Delete "${MIT_SCHEME_DOC_DIR}\mit-scheme-ref\*.*"
  RMDir "${MIT_SCHEME_DOC_DIR}\mit-scheme-ref"
  Delete "${MIT_SCHEME_DOC_DIR}\mit-scheme-imail\*.*"
  RMDir "${MIT_SCHEME_DOC_DIR}\mit-scheme-imail"
  Delete "${MIT_SCHEME_DOC_DIR}\index.html"
  RMDir "${MIT_SCHEME_DOC_DIR}"

  Delete "${MIT_SCHEME_LIB_DIR}\edwin\*.*"
  RMDir "${MIT_SCHEME_LIB_DIR}\edwin"

  Delete "${MIT_SCHEME_LIB_DIR}\runtime\*.*"
  RMDir "${MIT_SCHEME_LIB_DIR}\runtime"

  Delete "${MIT_SCHEME_LIB_DIR}\optiondb.scm"
  Delete "${MIT_SCHEME_LIB_DIR}\all.com"
  RMDir "${MIT_SCHEME_LIB_DIR}"

  Delete "${MIT_SCHEME_BIN_DIR}\*.*"
  RMDir "${MIT_SCHEME_BIN_DIR}"

  RMDir "$INSTDIR"

  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Website.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Documentation.lnk"
  Delete "$DESKTOP\MIT-GNU Scheme.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\MIT-GNU Scheme.lnk"

  RMDir "$SMPROGRAMS\$ICONS_GROUP"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey ${PRODUCT_DIR_ROOT_KEY} "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd
