/* -*-comment-start: "//";comment-end:""-*-
 * GNU Mes --- Maxwell Equations of Software
 * Copyright © 2018 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
 *
 * This file is part of GNU Mes.
 *
 * GNU Mes is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * GNU Mes is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Mes.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <libmes.h>

#include <dirent.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>

int
qsort_strcmp (void const* a, void const* b)
{
  return strcmp (*((char**) a), *((char**) b));
}

int
main ()
{
  DIR *d = opendir ("scaffold/tests/readdir-fu");
  if (d)
    return 1;
  if (errno != ENOENT)
    return 2;

  d = opendir ("scaffold/tests/99-readdir.c");
  if (d)
    return 3;
  if (errno != ENOTDIR)
    return 4;

  errno = 0;
  d = opendir ("scaffold/tests/readdir.dir");
  if (!d)
    return 5;

  if (errno)
    return 6;

  int i = 0;
  char* list[6] = {0};
  struct dirent *entry = readdir (d);
  if (!entry)
    return 7;
  oputs (entry->d_name);
  oputs ("\n");
  list[i++] = entry->d_name;

  entry = readdir (d);
  if (!entry)
    return 8;
  oputs (entry->d_name);
  oputs ("\n");
  list[i++] = entry->d_name;

  entry = readdir (d);
  if (!entry)
    return 9;
  oputs (entry->d_name);
  oputs ("\n");
  list[i++] = entry->d_name;

  entry = readdir (d);
  if (!entry)
    return 10;
  oputs (entry->d_name);
  oputs ("\n");
  list[i++] = entry->d_name;

  entry = readdir (d);
  if (!entry)
    return 11;
  oputs (entry->d_name);
  oputs ("\n");
  list[i++] = entry->d_name;

  entry = readdir (d);
  if (entry)
    return 12;

  oputs ("\nls:\n");
  qsort (list, 5, sizeof (char*), qsort_strcmp);
  for (int i = 0; i < 5; i++)
    {
      oputs (list[i]); oputs ("\n");
    }

  if (strcmp (list[0], "."))
    return 13;

  if (strcmp (list[4], "link"))
    return 14;

  return 0;
}
