/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

import gnu.kawa.util.AbstractHashTable;
import gnu.kawa.util.WeakHashNode;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWeakHashTable<K, V>
extends AbstractHashTable<WeakHashNode<V, V>, K, V> {
    ReferenceQueue<V> rqueue = new ReferenceQueue();

    public AbstractWeakHashTable() {
        super(64);
    }

    public AbstractWeakHashTable(int n) {
        super(n);
    }

    protected abstract K getKeyFromValue(V var1);

    @Override
    protected int getEntryHashCode(WeakHashNode<V, V> weakHashNode) {
        return weakHashNode.hash;
    }

    @Override
    protected WeakHashNode<V, V> getEntryNext(WeakHashNode<V, V> weakHashNode) {
        return weakHashNode.next;
    }

    @Override
    protected void setEntryNext(WeakHashNode<V, V> weakHashNode, WeakHashNode<V, V> weakHashNode2) {
        weakHashNode.next = weakHashNode2;
    }

    @Override
    protected K getEntryKey(WeakHashNode<V, V> weakHashNode) {
        V v = this.getEntryValue(weakHashNode);
        return v == null ? null : (K)this.getKeyFromValue(v);
    }

    @Override
    protected V getEntryValue(WeakHashNode<V, V> weakHashNode) {
        return (V)weakHashNode.get();
    }

    @Override
    protected void setEntryValue(WeakHashNode<V, V> weakHashNode, V v) {
        throw new UnsupportedOperationException();
    }

    protected WeakHashNode<V, V>[] allocEntries(int n) {
        return new WeakHashNode[n];
    }

    protected V getValueIfMatching(WeakHashNode<V, V> weakHashNode, K k) {
        V v = this.getEntryValue(weakHashNode);
        if (v != null && this.matches(this.getKeyFromValue(v), k)) {
            return v;
        }
        return null;
    }

    @Override
    public V get(K k, V v) {
        this.cleanup();
        int n = this.hash(k);
        int n2 = this.hashToIndex(n);
        WeakHashNode weakHashNode = ((WeakHashNode[])this.table)[n2];
        while (weakHashNode != null) {
            V v2 = this.getValueIfMatching(weakHashNode, k);
            if (v2 != null) {
                return v2;
            }
            weakHashNode = weakHashNode.next;
        }
        return v;
    }

    @Override
    public int hash(K k) {
        return System.identityHashCode(k);
    }

    protected boolean valuesEqual(V v, V v2) {
        return v == v2;
    }

    @Override
    protected WeakHashNode<V, V> makeEntry(K k, int n, V v) {
        return new WeakHashNode(v, this.rqueue, n);
    }

    @Override
    public V put(K k, V v) {
        this.cleanup();
        int n = this.hash(k);
        int n2 = this.hashToIndex(n);
        WeakHashNode weakHashNode = ((WeakHashNode[])this.table)[n2];
        Object object2 = weakHashNode;
        WeakHashNode weakHashNode2 = null;
        V v2 = null;
        while (true) {
            if (object2 == null) {
                if (++this.num_bindings >= ((WeakHashNode[])this.table).length) {
                    this.rehash();
                    n2 = this.hashToIndex(n);
                    weakHashNode = ((WeakHashNode[])this.table)[n2];
                }
                object2 = this.makeEntry((Object)null, n, (Object)v);
                ((WeakHashNode)object2).next = weakHashNode;
                ((WeakHashNode[])this.table)[n2] = object2;
                return v2;
            }
            V v3 = this.getEntryValue((WeakHashNode<V, V>)object2);
            if (v3 == v) {
                return v3;
            }
            WeakHashNode weakHashNode3 = ((WeakHashNode)object2).next;
            if (v3 != null && this.valuesEqual(v3, v)) {
                if (weakHashNode2 == null) {
                    ((WeakHashNode[])this.table)[n2] = weakHashNode3;
                } else {
                    weakHashNode2.next = weakHashNode3;
                }
                v2 = v3;
            } else {
                weakHashNode2 = object2;
            }
            object2 = weakHashNode3;
        }
    }

    protected void cleanup() {
        AbstractWeakHashTable.cleanup(this, this.rqueue);
    }

    static <Entry, K, V> void cleanup(AbstractHashTable<Entry, ?, ?> abstractHashTable, ReferenceQueue<?> referenceQueue) {
        Reference<?> reference;
        while ((reference = referenceQueue.poll()) != null) {
            int n = abstractHashTable.hashToIndex(abstractHashTable.getEntryHashCode(reference));
            Object Entry2 = null;
            Object Entry3 = abstractHashTable.table[n];
            while (Entry3 != null) {
                Entry Entry4 = abstractHashTable.getEntryNext((Reference<?>)Entry3);
                if (Entry3 == reference) {
                    if (Entry2 == null) {
                        abstractHashTable.table[n] = Entry4;
                        break;
                    }
                    abstractHashTable.setEntryNext((Reference<?>)Entry2, (Reference<?>)Entry4);
                    break;
                }
                Entry2 = Entry3;
                Entry3 = Entry4;
            }
            --abstractHashTable.num_bindings;
        }
    }
}

