/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.IntegerStack;
import gnu.jel.debug.Debug;
import gnu.jel.debug.Tester;
import java.util.Stack;

public class TypesStack
implements Cloneable {
    protected static Class tsb_class = null;
    protected static Class string_class = null;
    protected static Class[] unwrapClasses;
    public static final Class[] primitiveTypes;
    public static final char[] primitiveCodes;
    public static final String[] primitiveTypeNames;
    protected static final byte[] stkoccup;
    private IntegerStack primitiveIDs = new IntegerStack();
    private Stack classes = new Stack();
    protected int currWords = 0;
    private int maxWords = 0;
    private static final byte[] cvt_wide;

    public static int unwrapTypeID(Class cls) {
        int resID = -1;
        int i = 0;
        while (i < 8 && resID == -1) {
            if (unwrapClasses[i].isAssignableFrom(cls)) {
                resID = i;
            }
            ++i;
        }
        return resID;
    }

    public static final int primitiveID(Class c) {
        if (c == null || !c.isPrimitive()) {
            return 8;
        }
        int i = 0;
        while (i < primitiveTypes.length && primitiveTypes[i] != c) {
            ++i;
        }
        Debug.assert(i < primitiveTypes.length, "You didn't put _ALL_ primitive types into primitiveTypes array.");
        return i;
    }

    public static final int primitiveID(Object o) {
        if (o instanceof Boolean) {
            return 0;
        }
        if (o instanceof Byte) {
            return 1;
        }
        if (o instanceof Character) {
            return 2;
        }
        if (o instanceof Short) {
            return 3;
        }
        if (o instanceof Integer) {
            return 4;
        }
        if (o instanceof Long) {
            return 5;
        }
        if (o instanceof Float) {
            return 6;
        }
        if (o instanceof Double) {
            return 7;
        }
        return 8;
    }

    public Object clone() {
        TypesStack res = null;
        try {
            res = (TypesStack)super.clone();
            res.primitiveIDs = (IntegerStack)res.primitiveIDs.clone();
            res.classes = (Stack)res.classes.clone();
        }
        catch (CloneNotSupportedException exc) {
            Debug.reportThrowable(exc);
        }
        return res;
    }

    public final Class peek() {
        return (Class)this.classes.peek();
    }

    public final int peekID() {
        return this.primitiveIDs.peek();
    }

    public final Class peek(int i) {
        return (Class)this.classes.elementAt(this.classes.size() - 1 - i);
    }

    public final int peekID(int i) {
        return this.primitiveIDs.peek(i);
    }

    public final Class pop() {
        int id = this.primitiveIDs.pop();
        this.currWords -= stkoccup[id];
        Debug.assert(this.currWords >= 0);
        return (Class)this.classes.pop();
    }

    public final void pushID(int id, Class c) {
        this.primitiveIDs.push(id);
        if (id == 8) {
            this.classes.push(c);
        } else {
            this.classes.push(primitiveTypes[id]);
        }
        this.currWords += stkoccup[id];
        if (this.currWords > this.maxWords) {
            this.maxWords = this.currWords;
        }
    }

    public final void pushID(int id) {
        Debug.assert(id != 8);
        this.pushID(id, null);
    }

    public final void push(Class c) {
        this.pushID(TypesStack.primitiveID(c), c);
    }

    public final void push(Class cls, int i) {
        int id = TypesStack.primitiveID(cls);
        this.primitiveIDs.push(id, i);
        this.classes.insertElementAt(cls, this.classes.size() - i);
        this.currWords += stkoccup[id];
        if (this.currWords > this.maxWords) {
            this.maxWords = this.currWords;
        }
    }

    public final void pushID(int id, int i) {
        Class cls = primitiveTypes[id];
        this.primitiveIDs.push(id, i);
        this.classes.insertElementAt(cls, this.classes.size() - i);
        this.currWords += stkoccup[id];
        if (this.currWords > this.maxWords) {
            this.maxWords = this.currWords;
        }
    }

    public final int size() {
        return this.primitiveIDs.size();
    }

    public final void resetStats() {
        Debug.assert(this.currWords == 0);
        this.maxWords = 0;
    }

    public final void tempExcessWords(int nw) {
        if ((nw = this.currWords + nw) > this.maxWords) {
            this.maxWords = nw;
        }
    }

    public final int getMaxOccupation() {
        return this.maxWords;
    }

    public static boolean isWidening(Class t1, Class t2) {
        boolean pt1 = t1.isPrimitive();
        boolean pt2 = t2.isPrimitive();
        if (pt2 && pt1) {
            return TypesStack.isWidening(TypesStack.primitiveID(t1), TypesStack.primitiveID(t2));
        }
        if (pt2 ^ pt1) {
            int unwrapID = TypesStack.unwrapTypeID(t1);
            if (unwrapID > 0) {
                return TypesStack.isWidening(unwrapID, TypesStack.primitiveID(t2));
            }
            return false;
        }
        if (t1 == tsb_class && t2 == string_class || t2 == tsb_class && t1 == string_class) {
            return true;
        }
        return t2.isAssignableFrom(t1);
    }

    public static boolean isWidening(int it1, int it2) {
        if (it1 < 8 && it2 < 8) {
            return (cvt_wide[it2] & 128 >> it1) > 0;
        }
        return false;
    }

    public static boolean isString(Class c) {
        return c == string_class;
    }

    public static boolean isTSB(Class c) {
        return c == tsb_class;
    }

    public static Class normalizeTSB(Class c) {
        return c == tsb_class ? string_class : c;
    }

    protected static Number widen(Object o, int clsID) {
        switch (clsID) {
            case 0: {
                if (((Boolean)o).booleanValue()) {
                    return new Long(1L);
                }
                return new Long(0L);
            }
            case 1: {
                return (Number)o;
            }
            case 2: {
                return new Long(((Character)o).charValue());
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return (Number)o;
            }
        }
        Debug.println("Attempt to widen wrong primitive (" + clsID + ").");
        return new Long(0L);
    }

    protected static Object narrow(Number val, int clsID) {
        switch (clsID) {
            case 0: {
                if (val.longValue() != 0L) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 1: {
                return new Byte(val.byteValue());
            }
            case 2: {
                return new Character((char)val.longValue());
            }
            case 3: {
                return new Short(val.shortValue());
            }
            case 4: {
                return new Integer(val.intValue());
            }
            case 5: {
                return new Long(val.longValue());
            }
            case 6: {
                return new Float(val.floatValue());
            }
            case 7: {
                return new Double(val.doubleValue());
            }
        }
        Debug.println("Attempt to narrow wrong primitive (" + clsID + ").");
        return null;
    }

    public static void main(String[] args) {
        Tester t = new Tester(System.out);
        TypesStack.test(t);
        t.summarize();
    }

    public static void test(Tester t) {
        TypesStack ts = null;
        try {
            t.startTest("ID(Boolean.TYPE)==ID(new Boolean(true))");
            t.compare(TypesStack.primitiveID(Boolean.TYPE), TypesStack.primitiveID(new Boolean(true)));
            t.startTest("ID(Byte.TYPE)==ID(new Byte(0))");
            t.compare(TypesStack.primitiveID(Byte.TYPE), TypesStack.primitiveID(new Byte(0)));
            t.startTest("ID(\"string\".getClass())==8");
            t.compare(TypesStack.primitiveID("string".getClass()), 8);
        }
        catch (Throwable exc) {
            Debug.reportThrowable(exc);
            t.testFail();
        }
        try {
            t.startTest("Make a new types stack");
            ts = new TypesStack();
            t.testOK();
        }
        catch (Throwable exc) {
            Debug.reportThrowable(exc);
            t.testFail();
        }
        try {
            t.startTest("push(Integer.TYPE);pushID(4); pop()==pop()");
            ts.push(Integer.TYPE);
            ts.pushID(4);
            t.compare(ts.pop(), ts.pop());
        }
        catch (Throwable exc) {
            Debug.reportThrowable(exc);
            t.testFail();
        }
        try {
            t.startTest("push(Integer.TYPE,0);pushID(4,0); pop()==pop()");
            ts.push(Integer.TYPE, 0);
            ts.pushID(4, 0);
            t.compare(ts.pop(), ts.pop());
        }
        catch (Throwable exc) {
            Debug.reportThrowable(exc);
            t.testFail();
        }
        try {
            t.startTest("push(Long.TYPE);pushID(6);pushID(4,1);peekID()==peekID(1)+2");
            ts.push(Long.TYPE);
            ts.pushID(6);
            ts.pushID(4, 1);
            t.compare(ts.peekID(), ts.peekID(1) + 2);
        }
        catch (Throwable exc) {
            Debug.reportThrowable(exc);
            t.testFail();
        }
        try {
            t.startTest("pop();peekID()==peekID(1)-1");
            ts.pop();
            t.compare(ts.peekID(), ts.peekID(1) - 1);
        }
        catch (Throwable exc) {
            Debug.reportThrowable(exc);
            t.testFail();
        }
        try {
            t.startTest("getMaxOccupation()==4");
            t.compare(ts.getMaxOccupation(), 4);
        }
        catch (Throwable exc) {
            Debug.reportThrowable(exc);
            t.testFail();
        }
        try {
            t.startTest("pop();pop(); size()==0");
            ts.pop();
            ts.pop();
            t.compare(ts.size(), 0);
        }
        catch (Throwable exc) {
            Debug.reportThrowable(exc);
            t.testFail();
        }
    }

    static {
        try {
            string_class = Class.forName("java.lang.String");
            tsb_class = Class.forName("gnu.jel.TempStringBuffer");
            String[] unwrapClassNames = new String[]{"Boolean", "Byte", "Character", "Short", "Integer", "Long", "Float", "Double"};
            unwrapClasses = new Class[8];
            int i = 0;
            while (i < 8) {
                TypesStack.unwrapClasses[i] = Class.forName("gnu.jel.reflect." + unwrapClassNames[i]);
                ++i;
            }
        }
        catch (ClassNotFoundException exc) {
            Debug.reportThrowable(exc);
        }
        primitiveTypes = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, null, Void.TYPE};
        primitiveCodes = new char[]{'Z', 'B', 'C', 'S', 'I', 'J', 'F', 'D', 'L', 'V'};
        primitiveTypeNames = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double", "reference", "void"};
        stkoccup = new byte[]{1, 1, 1, 1, 1, 2, 1, 2, 1, 0};
        cvt_wide = new byte[]{-128, 64, 96, 80, 120, 92, 94, 95};
    }
}

