/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.OP;
import gnu.jel.OPfunction;
import gnu.jel.OPlist;
import gnu.jel.OPload;
import gnu.jel.OPunary;
import gnu.jel.TypesStack;
import gnu.jel.debug.Debug;
import gnu.jel.reflect.Method;
import java.util.Stack;

public class OPbinary
extends OPfunction {
    private int code;
    private int opsIDX;
    private boolean strcat = false;
    private static Method[] sb_append;
    private static Method sb_append_string;
    private static Class sb_class;
    private static Class string_class;
    private int paramcnt = 0;
    private static final String[] opNames;
    private static final String[] opSymbols;
    protected static final int[][] promotions;
    private static final int[][] ops;
    private static final int[][] openjumps;

    public OPbinary(TypesStack typesStk, Stack paramOPs, int code, OPlist list) throws IllegalStateException {
        Debug.assert(code >= 0 && code < opNames.length && opNames.length == opSymbols.length);
        this.code = code;
        int op2ID = typesStk.peekID();
        Class op2Type = typesStk.pop();
        int op1ID = typesStk.peekID();
        Class op1Type = typesStk.pop();
        OP p2CvtPlaceholder = (OP)paramOPs.pop();
        OP p1CvtPlaceholder = (OP)paramOPs.pop();
        if (op1ID < 8 && op2ID < 8) {
            if (code < 14 || code > 16) {
                this.opsIDX = promotions[op1ID][op2ID];
                if (this.opsIDX == 255) {
                    throw new IllegalStateException("Types " + op1Type + " and " + op2Type + " are incompatible for " + opNames[code] + " operation.");
                }
                if (op1ID != this.opsIDX) {
                    typesStk.pushID(op1ID);
                    list.addAfter(p1CvtPlaceholder, new OPunary(typesStk, this.opsIDX, null, false));
                    typesStk.pop();
                }
                if (op2ID != this.opsIDX) {
                    typesStk.pushID(op2ID);
                    list.addAfter(p2CvtPlaceholder, new OPunary(typesStk, this.opsIDX, null, false));
                    typesStk.pop();
                }
                if (ops[code][this.opsIDX] == 255) {
                    throw new IllegalStateException("The " + opNames[code] + " operation" + " is not defined for " + TypesStack.primitiveTypeNames[this.resID] + "s.");
                }
                this.resID = this.opsIDX;
                if (code >= 8 && code <= 13) {
                    this.resID = 0;
                }
            } else {
                this.opsIDX = this.resID = OPunary.unary_prmtns[op1ID];
                typesStk.pushID(op2ID);
                list.addAfter(p2CvtPlaceholder, new OPunary(typesStk, 4, null, true));
                typesStk.pop();
            }
        } else if (code == 0) {
            if (op1Type == string_class) {
                typesStk.push(op1Type);
                list.addAfter(p1CvtPlaceholder, new OPunary(typesStk, 8, TypesStack.tsb_class, false));
                typesStk.pop();
            } else if (!TypesStack.isTSB(op1Type)) {
                throw new IllegalStateException("First operand for string concatenation must be string.");
            }
            this.opsIDX = 8;
            this.resID = 8;
            this.resType = TypesStack.tsb_class;
            this.strcat = true;
        } else if (code == 19) {
            if (!op1Type.isArray()) {
                throw new IllegalStateException("The first operand of the array element access operation must be an array.");
            }
            if (!TypesStack.isWidening(op2ID, 4)) {
                throw new IllegalStateException("Can't automatically convert array index of type " + op2Type + " to int.");
            }
            if (op2ID != 4) {
                typesStk.pushID(op2ID);
                list.addAfter(p2CvtPlaceholder, new OPunary(typesStk, 4, null, false));
                typesStk.pop();
            }
            this.resType = op1Type.getComponentType();
            this.opsIDX = this.resID = TypesStack.primitiveID(this.resType);
        } else {
            throw new IllegalStateException("Operation \"" + opNames[code] + "\" is defined on primitive " + "types only.");
        }
        typesStk.pushID(this.resID, this.resType);
    }

    public int getNParams() {
        return 2;
    }

    protected void compile_pre(ClassFile cf) {
        this.paramcnt = 2;
    }

    protected void compile_par(ClassFile cf) {
        --this.paramcnt;
        if (this.code == 17 || this.code == 18) {
            if (this.paramcnt == 1) {
                cf.logical_param(this.code == 17);
            } else {
                cf.logical_end(this.code == 17);
            }
        } else {
            cf.ensure_value();
        }
    }

    protected void compile(ClassFile cf) {
        if (this.strcat) {
            cf.code(182);
            if (cf.typesStk.peek() == string_class) {
                cf.codeI(cf.getIndex(sb_append_string, 10));
            } else {
                cf.codeI(cf.getIndex(sb_append[cf.typesStk.peekID()], 10));
            }
            cf.typesStk.pop();
        } else if (this.code != 17 && this.code != 18) {
            cf.code(ops[this.code][this.opsIDX]);
            cf.currJump = openjumps[this.code][this.opsIDX];
            cf.typesStk.pop();
            cf.typesStk.pop();
            if (cf.currJump == 0) {
                cf.typesStk.pushID(this.resID, this.resType);
            }
        }
    }

    protected void eval(OPlist list) {
        if (this.code == 19) {
            return;
        }
        try {
            OPload c2 = (OPload)this.prev;
            OPload c1 = (OPload)this.prev.prev;
            if (this.strcat) {
                ((StringBuffer)c1.what).append(String.valueOf(c2.what));
            } else {
                Number n1 = TypesStack.widen(c1.what, c1.resID);
                Number n2 = TypesStack.widen(c2.what, c2.resID);
                boolean boolres = false;
                boolean resbool = false;
                if (this.opsIDX >= 6 && this.opsIDX <= 7) {
                    double d1 = n1.doubleValue();
                    double d2 = n2.doubleValue();
                    boolean wrop = false;
                    switch (this.code) {
                        case 0: {
                            d1 += d2;
                            break;
                        }
                        case 1: {
                            d1 -= d2;
                            break;
                        }
                        case 2: {
                            d1 *= d2;
                            break;
                        }
                        case 3: {
                            d1 /= d2;
                            break;
                        }
                        case 4: {
                            d1 %= d2;
                            break;
                        }
                        case 5: {
                            wrop = true;
                            break;
                        }
                        case 6: {
                            wrop = true;
                            break;
                        }
                        case 7: {
                            wrop = true;
                            break;
                        }
                        case 8: {
                            boolres = true;
                            resbool = d1 == d2;
                            break;
                        }
                        case 9: {
                            boolres = true;
                            resbool = d1 != d2;
                            break;
                        }
                        case 10: {
                            boolres = true;
                            resbool = d1 < d2;
                            break;
                        }
                        case 11: {
                            boolres = true;
                            resbool = d1 >= d2;
                            break;
                        }
                        case 12: {
                            boolres = true;
                            resbool = d1 > d2;
                            break;
                        }
                        case 13: {
                            boolres = true;
                            resbool = d1 <= d2;
                            break;
                        }
                        default: {
                            wrop = true;
                        }
                    }
                    if (wrop) {
                        Debug.println("Wrong operation on float (" + this.code + ").");
                    }
                    n1 = !boolres ? (Number)new Double(d1) : (Number)(resbool ? new Long(1L) : new Long(0L));
                } else {
                    long l1 = n1.longValue();
                    long l2 = n2.longValue();
                    switch (this.code) {
                        case 0: {
                            l1 += l2;
                            break;
                        }
                        case 1: {
                            l1 -= l2;
                            break;
                        }
                        case 2: {
                            l1 *= l2;
                            break;
                        }
                        case 3: {
                            l1 /= l2;
                            break;
                        }
                        case 4: {
                            l1 %= l2;
                            break;
                        }
                        case 5: 
                        case 17: {
                            l1 &= l2;
                            break;
                        }
                        case 6: 
                        case 18: {
                            l1 |= l2;
                            break;
                        }
                        case 7: {
                            l1 ^= l2;
                            break;
                        }
                        case 8: {
                            boolres = true;
                            l1 = l1 == l2 ? 1L : 0L;
                            break;
                        }
                        case 9: {
                            boolres = true;
                            l1 = l1 != l2 ? 1L : 0L;
                            break;
                        }
                        case 10: {
                            boolres = true;
                            l1 = l1 < l2 ? 1L : 0L;
                            break;
                        }
                        case 11: {
                            boolres = true;
                            l1 = l1 >= l2 ? 1L : 0L;
                            break;
                        }
                        case 12: {
                            boolres = true;
                            l1 = l1 > l2 ? 1L : 0L;
                            break;
                        }
                        case 13: {
                            boolres = true;
                            l1 = l1 <= l2 ? 1L : 0L;
                            break;
                        }
                        case 14: {
                            l1 <<= (int)l2;
                            break;
                        }
                        case 15: {
                            l1 >>= (int)l2;
                            break;
                        }
                        case 16: {
                            if (this.resID == 4) {
                                l1 = (int)l1 >>> (int)l2;
                                break;
                            }
                            l1 >>>= (int)l2;
                            break;
                        }
                        default: {
                            Debug.println("Wrong operation on integer (" + this.code + ").");
                        }
                    }
                    n1 = new Long(l1);
                }
                if (boolres) {
                    c1.what = TypesStack.narrow(n1, 0);
                    c1.resType = Boolean.TYPE;
                    c1.resID = 0;
                } else {
                    c1.what = TypesStack.narrow(n1, this.resID);
                }
            }
            list.remove(this.prev);
            list.remove(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String toString() {
        return opSymbols[this.code];
    }

    static {
        try {
            sb_class = Class.forName("java.lang.StringBuffer");
            string_class = Class.forName("java.lang.String");
            Class[] param = new Class[]{string_class};
            sb_append_string = new Method(sb_class.getMethod("append", param));
            sb_append = new Method[9];
            param[0] = Class.forName("java.lang.Object");
            OPbinary.sb_append[8] = new Method(sb_class.getMethod("append", param));
            int i = 0;
            while (i < 8) {
                param[0] = TypesStack.primitiveTypes[i == 1 ? 4 : (i == 3 ? 4 : i)];
                OPbinary.sb_append[i] = new Method(sb_class.getMethod("append", param));
                ++i;
            }
        }
        catch (Exception exc) {
            Debug.reportThrowable(exc);
        }
        opNames = new String[]{"add", "substract", "multiply", "divide", "remainder", "bitwise and", "bitwise or", "bitwise xor", "equal", "not equal", "less", "greater or equal", "greater", "less or equal", "left shift", "signed right shift", "unsigned right shift", "logical and", "logical or", "array element access"};
        opSymbols = new String[]{"+", "-", "*", "/", "%", "&", "|", "^", "==", "!=", "<", ">=", ">", "<=", "<<", ">>", ">>>", "&&", "||", "{}"};
        promotions = new int[][]{{0, 255, 255, 255, 255, 255, 255, 255}, {255, 4, 4, 4, 4, 5, 6, 7}, {255, 4, 4, 4, 4, 5, 6, 7}, {255, 4, 4, 4, 4, 5, 6, 7}, {255, 4, 4, 4, 4, 5, 6, 7}, {255, 5, 5, 5, 5, 5, 6, 7}, {255, 6, 6, 6, 6, 6, 6, 7}, {255, 7, 7, 7, 7, 7, 7, 7}};
        ops = new int[][]{{255, 96, 255, 96, 96, 97, 98, 99, 255}, {255, 100, 255, 100, 100, 101, 102, 103, 255}, {255, 104, 255, 104, 104, 105, 106, 107, 255}, {255, 108, 255, 108, 108, 109, 110, 111, 255}, {255, 112, 255, 112, 112, 113, 114, 115, 255}, {126, 126, 255, 126, 126, 127, 255, 255, 255}, {128, 128, 255, 128, 128, 129, 255, 255, 255}, {130, 130, 255, 130, 130, 131, 255, 255, 255}, {0, 0, 0, 0, 0, 148, 150, 152, 255}, {0, 0, 0, 0, 0, 148, 150, 152, 255}, {0, 0, 0, 0, 0, 148, 150, 152, 255}, {0, 0, 0, 0, 0, 148, 149, 151, 255}, {0, 0, 0, 0, 0, 148, 149, 151, 255}, {0, 0, 0, 0, 0, 148, 150, 152, 255}, {120, 120, 120, 120, 120, 121, 255, 255, 255}, {122, 122, 122, 122, 122, 123, 255, 255, 255}, {124, 124, 124, 124, 124, 125, 255, 255, 255}, {0, 255, 255, 255, 255, 255, 255, 255, 255}, {0, 255, 255, 255, 255, 255, 255, 255, 255}, {51, 51, 52, 53, 46, 47, 48, 49, 50}};
        openjumps = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {159, 159, 159, 159, 159, 153, 153, 153, 0}, {160, 160, 160, 160, 160, 154, 154, 154, 0}, {161, 161, 161, 161, 161, 155, 155, 155, 0}, {162, 162, 162, 162, 162, 156, 156, 156, 0}, {163, 163, 163, 163, 163, 157, 157, 157, 0}, {164, 164, 164, 164, 164, 158, 158, 158, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}};
    }
}

