# GNU Typist - improved typing tutor program for UNIX systems
# Copyright (C) 1998  Simon Baldwin (simonb@sco.com)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

#------------------------------------------------------------------------------
# Series D
#------------------------------------------------------------------------------
G:_D_MENU
*:_D_NO_MENU

#------------------------------------------------------------------------------
# Lesson D1
#------------------------------------------------------------------------------
*:D1
*:_D_S_D1
B:                            Lesson D1

*:_D_R_L0
T:			Welcome to the Dvorak Course
 :
 :This course has been planned for beginners as well as experienced typists.
 :If you are a beginner learning to type on the Dvorak keyboard (the American
 :Simplified Keyboard), you will find this keyboard easier to learn than the
 :QWERTY (Sholes) keyboard.
 :
 :This is because the Dvorak keyboard has been scientifically designed to minimize
 :cumulative finger motion while typing English.  The ten letters on the home row
 :(A, O, E, U, I, D, H, T, N, and S) make up about 70% of all keystrokes. These
 :ten letters alone can form over 3000 words.  Needless to say, having these keys
 :in the home row facilitates both speed and accuracy.
 :
 :If you are already an experienced typist on the Sholes keyboard, don't despair:
 :you won't have to unlearn everything you know.  Your basic typing dexterity
 :remains with you, regardless of the keyboard layout.  Learning the Dvorak
 :keyboard is like learning to "play on a new surface", as a tennis player must
 :learn to adjust to grass court or hard court when she has been accustomed to
 :playing on a clay court.

*:_D_R_L1
T:			General Instructions
 :
 :The fingers of the left hand should be placed over the A-key, the O-key,
 :the E-key, and the U-key.  Similarly, the fingers of the right hand should be
 :placed over the H-key, the T-key, the N-key, and the S-key.

I:(1) Home Row Exercises
*:_D_R_L2
D:aoeu ueoa aoeui snth htns snthd uihd uihd
 :asonetuhid asonetuhid dihutenosa dihutenosa

I:(2)
*:_D_R_L3
D:a s o n e t u h i d  a s o n e t u h i d

I:(3)
*:_D_R_L4
D:d i h u t e n o s a  d i h u t e n o s a

I:(4)
*:_D_R_L5
D:as an at ah ad aa ao ae au ai os on ot oh od oi ou oe oo oa
 :es en et eh ed ea eo ee eu ei us un ut uh ud ui uu ue uo ua

I:(5)
*:_D_R_L6
D:his hat is an aid in the hot sun
 :in his sad sod hut he sat on his hen

I:(6)
*:_D_R_L7
D:sue did not use his hoe and tin hat
 :dan did not see the dot on his tie as he hid his tan hat

I:(7)
*:_D_R_L8
D:ada add ado aha aid ann dad dan dee den did die din don dot dud
 :due dun duo eda end had has hat hen hid his hit hod hoe hot hue
 :hut ian ida inn ion its nat ned net nod not nun nut odd ode out
 :sat sit sod son sot sun tan tat tee ten tho tit toe ton too tot

I:(8)
*:_D_R_L9
D:i do as i do and the end is not as sad as the one sid had

G:_D_E_D1

#------------------------------------------------------------------------------
# Lesson D2
#------------------------------------------------------------------------------
*:D2
*:_D_S_D2
B:                            Lesson D2

*:_D_R_L10
T:                    Learning the Shift Key
 :
 :To integrate the shift key rhythmically in your practice, a capital letter
 :should take three beats: 1--press the shift key opposite the hand to press
 :the letter; 2--press the letter; 3--release the shift key.

I:(1) Review
*:_D_R_L11
D:een ent est ett hin hou ith ion oth sen tha thi tio tte thu

I:(2)
*:_D_R_L12
D:Ada An Ana Ann Dad Dan Dee Ed Eta
 :Dan Nan Nat Ned Sid Sue Tad Ted Tod

I:(3)
*:_D_R_L13
D:The sad tots sat on a tan seat in his neat tent and ate ten nuts
 :On his date Otis had a thin suit and no tint on his shoes

I:(4)
*:_D_R_L14
D:Enos eats a thin hash diet in a hued dish as he sits on an odd seat
 :Dad does not eat suet   He had seen Sue dent his auto

I:(5)
*:_D_R_L15
D:ad an de di ed en es ie in ne un ate dis ess eat ied ine
 :ist ite nee nes non nus ses tes tis usi ante anti ates
 :eous eats ines ions ious ists itas itis ness sion tion

I:(6)
*:_D_R_L16
D:Adna Anna Anne Dana Dead Edie Edna Enid Etta Heda
 :Nate Nina Neta Nona Odie Ohio Otto Stan Tess Thad Theo

I:(7)
*:_D_R_L17
D:adds aids ante ants aunt dead deed dens died dies dine dins dodo
 :heed hens hied hind hint hiss hist hits hods hoed hoes hone hood
 :none noon noun nuns oats odds odes ones sane sash sate seas seed
 :sees sent sets shad shed shin shot side sine sins sons sued suns
 :tide tine tins toad tone toss tote tout tune undo unit used uses

G:_D_E_D2

#------------------------------------------------------------------------------
# Lesson D3
#------------------------------------------------------------------------------
*:D3
*:_D_S_D3
B:                            Lesson D2

T:                    Home Row and the Period
 :
 :The period is above the E-finger.  Note that the end of a sentence is
 :always followed by two spaces; in abbreviations, it is followed by one
 :space.

#
I:(1)
*:_D_R_L18
D:e.  e.  e.  e.  a.  s.  o.  n.  e.  t.  u.  h.  i.  d.  a.  a.
 :h.  u.  a.  i.  o.  n.  s.  d.  t.  e.  h.  o.  u.  i.  s.  a.

I:(2)
*:_D_R_L19
D:anno athe atio atte ause diti enon esen enti este
 :ethe esti ette hese hous hout iate iend ines inst
 :ith itio into ndin ness nnot noth ntio onth osed
 :thei thes tion tten nest nude unti usin tand tate

I:(3)
*:_D_R_L20
D:Adana Andie Annie Aonia Audie Denis Diana Dinah
 :Donna Duane Edith Ethan India Susan Susie Thane
 :Adana.  Andie.  Annie.  Aonia.  Audie.  Denis.  Diana.  Dinah.

I:(4)
*:_D_R_L21
D:In the house Adana dined in haste on toast and dates.
 :Sated as she had eaten she noted the sheen on the dunes
 :and the shade in the sheds.  She hates to see an idiot
 :stand and shoot his tenth doe in the dense heath.

I:(5)
*:_D_R_L22
D:An onion heats and stuns stout noses and sends hands
 :to douse teeth and hoist suede hoods onto heads.

I:(6)
*:_D_R_L23
D:eates eousness eousnesses esses iates iests iness inesses
 :iousness iousnesses iohness iohnesses itions nesses ousness

G:_D_E_D3

#------------------------------------------------------------------------------
# Lesson D4
#------------------------------------------------------------------------------
*:D4
*:_D_S_D4
B:                            Lesson D4

*:_D_R_L24
T:                    Upper Row and Essential Punctuation

I:(1)
*:_D_R_L25
D:tctc upup hghg o,o, nrnr a/a/ slsl a?a? s-s- s--- s---- ----
 :tctc upup hghg, hfhf uyuy, nrnr, slsl, s---, s-s-, a/a/-

I:(2)
*:_D_R_L26
D:tctc/ upup/ hghg/ uyuy/ hfhf/ nrnr/ slsl/ tctc/ hfhf/ hghg/
 :tctc? upup? hghg? uyuy? nrnr? slsl? hfhf? upup- hghg- tctc-

I:(3)
*:_D_R_L27
D:Al el if of or up Al el if of or up
 :go la lo pa pi ye go la lo pa pi ye

I:(4)
*:_D_R_L28
D:Can pa go aft and lie on our old cot?
 :The shy ape put on a red hat and ran off the lot.
 :For a top fee, her act is to hop in, lie on the rug, pat her
 :pet cat, fit a fur on her ear, get her fan, and run off.

I:(5)
*:_D_R_L29
D:ago ail ale all apt arc are art cur cut dig dip dop
 :dry dug eel egg ego fag fig fin fir fly fog for fro
 :fry gag gap gas gay gin gip God goo gun hag hay hep

G:_D_E_D4

#------------------------------------------------------------------------------
# Lesson D5
#------------------------------------------------------------------------------
*:D5
*:_D_S_D5
B:                            Lesson D5

I:(1) Review
*:_D_R_L30
D:The left road can lead the lads and lady to good lots near
 :your land.  The sale of pure gold is held at your door.

I:(2)
*:_D_R_L31
D:You held no fear of loss for a year.  On each trip to your
 :shop he paid in cash for the caps, fish, cups, pans, fuel,
 :logs, peas, ales, rice and fats you sold.

I:(3)
*:_D_R_L32
D:It is a fact that a slap on the face can hurt.  The poor
 :apes feel free to find a sure sort of life in the dale.

I:(4)
*:_D_R_L33
D:aces acts ages ails airs also arcs call caps card cold cops
 :else errs eyes face fair fall fare fate feat feel feet fell
 :gate gets gift gigs glad goat goes gone gosh gray grey gull
 :hole hope hops huff hull ills ires last late lest lets lies

I:(5)
*:_D_R_L34
D:pear pert pest pets pits plop pops post pots puns puts rate real
 :ride rids ripe rips rope rote rues ruff runs runt rush rust ruts
 :span spat spin spit spot spun step stop tags tall tape taps tars
 :ugly upon ruge user yard year yeas yell yelp yips yoga yule your

G:_D_E_D5

#------------------------------------------------------------------------------
# Lesson D6
#------------------------------------------------------------------------------
*:D6
*:_D_S_D6
B:                            Lesson D6

*:_D_R_L35
T:		Learning the Lower Row

I:(1)
*:_D_R_L36
D:a'sz oqnv ukhm uxhb a"o- oqnv ejtw a'sz uxhb ukkk ukhm a's-

I:(2)
*:_D_R_L37
D:uk sz-a' tw nv ej hm uk a" hb oq uk a' nv hm a" oq sz tw ej

I:(3)
*:_D_R_L38
D:ale any are ary augh aught ave ay aye ec ece eco el er ere ery ex
 :exa exe far fer fir for ify igh ight il ile ill ily ire aze ize
 :la lly ly my ny ome or ore ough ought ould our re rec sive tive

I:(4)
*:_D_R_L39
D:I owe him a bun, a ham, ink, a bed and a job.
 :Sam was mad at his own new ox in the bin.
 :At the zoo, the wee, bad boa in a box bit Tom, Bob and me.

I:(5)
*:_D_R_L40
D:am ax be ma me ox oz we adz awe ban but eke eve haw hem
 :hub jab jam jaw jet jib job Joe jot jut kid kin kit man
 :mat Max nab new nub now own quo saw sox sum van vex vie
 :vow wan who win won yen you zax

G:_D_E_D6

#------------------------------------------------------------------------------
# Lesson D7
#------------------------------------------------------------------------------
*:D7
*:_D_S_D7
B:                            Lesson D7

I:(1)
*:_D_R_L41
D:In a daze the band hums the same new tune as they zoom down the exit.

I:(2)
*:_D_R_L42
D:Next time, I must have a town home, with a book and a vast tome,
 :bees, oxen, hams in the oven, rows of beans, the wind and a view.

I:(3)
*:_D_R_L43
D:I know six men wait to put down their axes.  They want to quit
 :their jobs when the job zone size is too wide.

I:(4)
*:_D_R_L44
D:ahem aims ajax akin asks atom axis bans bath beak beck been
 :hoax husk inks item jabs jade jamb Java jazz Jean jest jinx
 :knot Knox made maid mail mate mean meet mend mess mind mine

I:(5)
*:_D_R_L45
D:miss mist most musk must nabs news next nibs numb owed owes
 :quiz save saws seem sews skat skew skid skin some sums take
 :vend vent vest veto vise void vote wand weed week wend wins
 :whet whit whiz whom wish wont zebu zest zinc Zion zone zulu

G:_D_E_D7

#------------------------------------------------------------------------------
# Lesson D8
#------------------------------------------------------------------------------
*:D8
*:_D_S_D8
B:                            Lesson D8

I:(1)
*:_D_R_L46
D:He asked about those zebra waits in his beans.

I:(2)
*:_D_R_L47
D:It seems that in a month taxes on homes have taken all we saved.

I:(3)
*:_D_R_L48
D:John Smith makes a quiet visit to the bases in the winds and
 :weeds on the mound.

I:(4)
*:_D_R_L49
D:ovals ovoid oxide quake queen quest quite quits quote saves seams
 :skein skink skunk sweat takes taken taxed teams teems thank think
 :thumb times towns ukase vaunt vests vises visit vista vivid vixen
 :waits wands wants wends whine white whose zebus zoned zones zulus

G:_D_E_D8

#------------------------------------------------------------------------------
# Lesson D9
#------------------------------------------------------------------------------
*:D9
*:_D_S_D9
B:                            Lesson D9

I:(1)
*:_D_R_L50
D:hghm hbfb upxp uxyx twcw ej.j nvrv oq,q szlz a'?' a"/"

I:Again...
*:_D_R_L51
D:hghm hbfb upxp uxyx twcw ej.j nvrv oq,q szlz a'?' a"/"

I:(2)
*:_D_R_L52
D:gm mg fb bf pk kp yx xy cw wc .j j. rv vr ,q q, lz zl

I:(3)
*:_D_R_L53
D:My big boy may buy a gem at the labs by the bay.

I:(4)
*:_D_R_L54
D:Mort awes boys with the way he can ward off a blow, kill
 :elks and game, row a yawl, or ram awls into bars.

I:(5)
*:_D_R_L55
D:ah Al am an as at ax ba be do ed eh el go
 :ha he hi ho if in is it Jo la no ma me no
 :of oh on or ox pa pi Si so to up us we ye

G:_D_E_D9

#------------------------------------------------------------------------------
# Lesson D10
#------------------------------------------------------------------------------
*:D10
*:_D_S_D10
B:                            Lesson D10

I:(1)
*:_D_R_L56
D:In barns on farms chicks, boars, veals, bucks and stock might
 :enjoy and value an extra quart of water daily.

I:(2)
*:_D_R_L57
D:Do zebras roam the miles of bleak velds which cover parts of the
 :world while packs of brown bears and wart hogs prowl in the woods?

I:(3)
*:_D_R_L58
D:Some folks claim to favor poems and rhyme, others can wring equal
 :cheer and worth from words and quest and seize all books.  Still
 :others amply quell their needs with vocal music and seek all
 :works on voice.

I:(4)
*:_D_R_L59
D:To begin to use wrong verbs among boors and bores may be
 :a severe error even if the whole group seems to think
 :that exact terms mean less than is normal for them.

I:(5)
*:_D_R_L60
D:allow among avail awful Aztec azure backs balls began being belie
 :bells bills black blank bored borne bring can't chalk champ charm
 :check cheek chick chink comes Czech every evict exalt excel exert
 :exile expel exult Felix folks gable gauze gives glaze gleam globe

I:(6)
*:_D_R_L61
D:verge verse verve vetch vigil vigor viola virus vital vogue voile
 :vouch vowel vying walks walls wards warts whack whale wharf wheat
 :wheel whelp where which whiff while whirl whole wired wires words
 :world worth would write wrong wrote yards yokes yoks zippy zombie

G:_D_E_D10

#------------------------------------------------------------------------------
# Lesson D11
#------------------------------------------------------------------------------
*:D11
*:_D_S_D11
B:                            Lesson D11

I:(1)
*:_D_R_L62
D:For a meal we lack a room, milk in mugs, warm pork, veal
 :in the oven and cake.

I:(2)
*:_D_R_L63
D:Mike and Milt were grim, not calm, when Mort came to warn them that
 :the well worn ramp over to the mill was too wet for our mile walk.

I:(3)
*:_D_R_L64
D:Walt may quip and quote with zeal about too much work, but I
 :saw him melt and mourn about his love for his lost wife.

I:(4)
*:_D_R_L65
D:The pick of wool from rams can make very soft warm garb.

I:(5)
*:_D_R_L66
D:For his meal the busy bird will use his bill or beak in many
 :ways to peck at or ably to pick up a worm.

I:(6)
*:_D_R_L67
D:Owls on the wing may move away with limp easy grace or they
 :may sit on a wire and look ever so wise.

I:(7)
*:_D_R_L68
D:The word or term--prop, mall, king, mark, romp, lock or link--
 :can vary in what it may mean.

I:(8)
*:_D_R_L69
D:helm herb hock holy jeep jeer jell jerk John jolt jump jury
 :kale keel kelp kilt lack laws leak leek levy lick like lime
 :limp link live love luck lump lynx mail many mill more much
 :okra oval pack peak peck peek phew puck ramp rime skip talk

I:(9)
*:_D_R_L70
D:puck ramp rime skip talk vail vale vary veal veer veld verb vial vice
 :volk walk ware warm warp wars wart ways weal wear well will tilt wire
 :whey whim whip whir wore work worm worn yawn yolk zany zero zinc zing

G:_D_E_D11

#------------------------------------------------------------------------------
# Lesson D12
#------------------------------------------------------------------------------
*:D12
*:_D_S_D12
B:                            Lesson D12

I:(1)
*:_D_R_L71
D:In barns on farms chicks, bears, veals, bucks and stock might
 :enjoy and value an extra quart of water daily.

I:(2)
*:_D_R_L72
D:Quick quips, awful quotes and queer talks never quite solve
 :the wants of a very small child.

I:(3)
*:_D_R_L73
D:Do zebras roam the miles of bleak velds which cover parts of the
 :world while packs of brown bears and wart hogs prowl in the woods?

I:(4)
*:_D_R_L74
D:Some folks claim to favor poems and rhyme, others can wring equal
 :cheer and worth from words and quest and seize all books.  Still
 :others amply quell their needs with vocal music and seek all
 :works on voice.

I:(5)
*:_D_R_L75
D:The queen was given a query for which an ample reply would
 :take a quire of paper.

I:(6)
*:_D_R_L76
D:Six husky cooks boiled clam broth, shrimp and prawns and broiled
 :liver for seven lucky elves, then made their hasty exits.

I:(7)
*:_D_R_L77
D:At the games, Mark was so very badly hurt with many broken bones,
 :lumps on his jaws, and some glands burst.  Blood oozed from a crack
 :in his wart where it had oozed for weeks.  He was lucky to have lived.

I:(8)
*:_D_R_L78
D:To check pomp and pride, sever from all overt vices, belay all
 :forms of muck raking, and limit all hazards, will bring prime joy.

I:(9)
*:_D_R_L79
D:To begin to use wrong verbs among boors and bores may be
 :a severe error even if the whole group seems to think
 :that exact terms mean less than is normal for them.

I:(10)
*:_D_R_L80
D:allow among avail awful Aztec azure backs balls began being belie
 :bells bills black blank bored borne bring can't chalk champ charm
 :check cheek chick chink comes Czech every evict exalt excel exert
 :exile expel exult Felix folks gable gauze gives glaze gleam globe

I:(11)
*:_D_R_L81
D:grams grave graze havoc hazel helix hobby jazzy jelly jerky jewel
 :joker jolly jolts jowls judge junco kapok kayak keels keeps kitty
 :knack kneel knelt knock knurl kopek kraal Krupp leave liver money
 :never Ozark pawns peaks pecks peeks phlox pirks power proms prove

I:(12)
*:_D_R_L82
D:quack quaff quail qualm quays quell quill quilt ramps romps rooms
 :rumps salve serve shack shark shawl shirk shock shrew shuck sieve
 :seize skiff skill skimp skirt skulk small spank speak spoke stick
 :stuck threw throw thyme vague valid value valve vapid vault venal

I:(13)
*:_D_R_L83
D:verge verse verve vetch vigil vigor viola virus vital vogue voile
 :vouch vowel vying walks walls wards warts whack whale wharf wheat
 :wheel whelp where which whiff while whirl whole wired wires words
 :world worth would write wrong wrote yards yokes yolks zippy zombi

G:_D_E_D12

#------------------------------------------------------------------------------
# Lesson D13
#------------------------------------------------------------------------------
*:D13
*:_D_S_D13
B:                            Lesson D13

*:_D_R_L84
T:
 :The following 135 words are so frequently used that they comprise 50%
 :of all words normally typed.  If you can type the next two exercises without
 :errors, half of your typed words will be correct!

*:_D_R_L85
D:a about after all also an and another any are as at back be because
 :been before being between both but by can could day did do down each
 :even first for from get good had has have he her here him his how I
 :if in into is it its just know last life like little long made make
 :many may me men more most Mr.  Ms.  much must my never new no not now

*:_D_R_L86
D:of or on one only or other our out over own people said same see she
 :should so some state still such than that the their them then there
 :these they this those through time to too two under up very was way
 :we well were what when where which while who will with work would
 :years you your

*:_D_R_L87
T:We now concentrate on home row words.

I:(1)
*:_D_R_L88
D:The duteous dietitian hesitated at the intense nauseousness inside
 :the dishonest institution.

I:(2)
*:_D_R_L89
D:In addition, the unastute assassin had another unsound idea.  He
 :intended to assassinate the dishonest attendant at the institute.

I:(3)
*:_D_R_L90
D:The unintentioned noisiness and untidiness in the hostess house
 :astonished, astounded and nauseated Antonietta.  Undaunted and
 :unassisted, she did not hesitate to initiate a statute at the state
 :house.  The statute stated that no attendant in an untenanted haunted
 :hostess house is to attain hostess status.

G:_D_E_D13

#------------------------------------------------------------------------------
# Lesson D14
#------------------------------------------------------------------------------
*:D14
*:_D_S_D14
B:                            Lesson D14

*:_D_R_L91
T:
 :In this lesson we practice alphabetic sentences.

I:(1)
*:_D_R_L92
D:Sixty-five quizzical sheep kept their jaws dry in a farm bungalow.

I:(2)
*:_D_R_L93
D:Balky Zulus find they can hoax weary men with quavery jumping.

I:(3)
*:_D_R_L94
D:Jerome quickly began to be vexed by the powerful blizzards.

I:(4)
*:_D_R_L95
D:Squawking gorillas could vex the brazen nymphs in a jiffy.

I:(5)
*:_D_R_L96
D:Can Jerry's equipment file saws, ax, hoe, knives and grind adz?

I:(6)
*:_D_R_L97
D:Ben works at squeezing very juicy plums with flexed thumbs.

I:(7)
*:_D_R_L98
D:The black wizard quipping jovially flexed his muscles.

I:(8)
*:_D_R_L99
D:Will you pack my jugs of liquid veneer in five dozen boxes?

I:(9)
*:_D_R_L100
D:Could the wizard jinx quivering folks by magic yelps?

I:(10)
*:_D_R_L101
D:Brazen gazelles quickly examined the forward jeep.

I:(11)
*:_D_R_L102
D:The brown dog quickly jumped over the lazy fox.

I:(12)
*:_D_R_L103
D:Will the kind judge squelch the five or six brazen nymphs?

I:(13)
*:_D_R_L104
D:Mix zippy Kadota figs with quivering cranberry jelly.

I:(14)
*:_D_R_L105
D:The wives quickly jerked extra big pizzas from the stand.

I:(15)
*:_D_R_L106
D:Lisa quickly mixed the very big jar of new soap.

I:(16)
*:_D_R_L107
D:The major will fix a quiet cozy nook for the vexed, bad Gypsy.

I:(17)
*:_D_R_L108
D:Pairs of lazy knowing oxen came by quietly evading the jam.

I:(18)
D:Juvenile zest for excitement whetted interest in parking by the quay.

I:(19)
*:_D_R_L109
D:Put your big ax, shovel and quartz where Mike's fence joins ours.

I:(20)
*:_D_R_L110
D:The brawny jaguar held fast till the quaking Zouave victim expired.

G:_D_E_D14

#------------------------------------------------------------------------------
# Lesson series D jump tables
#------------------------------------------------------------------------------
*:_D_E_D1
Q: Do you want to continue to lesson D2 [Y/N] ? 
N:_D_MENU
G:_D_S_D2
*:_D_E_D2
Q: Do you want to continue to lesson D3 [Y/N] ? 
N:_D_MENU
G:_D_S_D3
*:_D_E_D3
Q: Do you want to continue to lesson D4 [Y/N] ? 
N:_D_MENU
G:_D_S_D4
*:_D_E_D4
Q: Do you want to continue to lesson D5 [Y/N] ? 
N:_D_MENU
G:_D_S_D5
*:_D_E_D5
Q: Do you want to continue to lesson D6 [Y/N] ? 
N:_D_MENU
G:_D_S_D6
*:_D_E_D6
Q: Do you want to continue to lesson D7 [Y/N] ? 
N:_D_MENU
G:_D_S_D7
*:_D_E_D7
Q: Do you want to continue to lesson D8 [Y/N] ? 
N:_D_MENU
G:_D_S_D8
*:_D_E_D8
Q: Do you want to continue to lesson D9 [Y/N] ? 
N:_D_MENU
G:_D_S_D9
*:_D_E_D9
Q: Do you want to continue to lesson D10 [Y/N] ? 
N:_D_MENU
G:_D_S_D10
*:_D_E_D10
Q: Do you want to continue to lesson D11 [Y/N] ? 
N:_D_MENU
G:_D_S_D11
*:_D_E_D11
Q: Do you want to continue to lesson D12 [Y/N] ? 
N:_D_MENU
G:_D_S_D12
*:_D_E_D12
Q: Do you want to continue to lesson D13 [Y/N] ? 
N:_D_MENU
G:_D_S_D13
*:_D_E_D13
Q: Do you want to continue to lesson D14 [Y/N] ? 
N:_D_MENU
G:_D_S_D14
*:_D_E_D14
G:_D_MENU

#------------------------------------------------------------------------------
# Lesson series D menu
#------------------------------------------------------------------------------
*:_D_MENU
B:                  Dvorak touch typing lessons
M: UP=_EXIT "The D series contains the following 14 lessons"
 :_D_S_D1  "Lesson D1     The home row"
 :_D_S_D2  "Lesson D2     Learning the Shift Key"
 :_D_S_D3  "Lesson D3     Home Row and the Period"
 :_D_S_D4  "Lesson D4     Upper Row and Essential Punctuation"
 :_D_S_D5  "Lesson D5     Review"
 :_D_S_D6  "Lesson D6     Learning the Lower Row"
 :_D_S_D7  "Lesson D7     Practise"
 :_D_S_D8  "Lesson D8     Practise"
 :_D_S_D9  "Lesson D9     Practise"
 :_D_S_D10 "Lesson D10    Practise"
 :_D_S_D11 "Lesson D11    Practise"
 :_D_S_D12 "Lesson D12    Practise"
 :_D_S_D13 "Lesson D13    Frequent words"
 :_D_S_D14 "Lesson D14    Alphabetic sentences"
*:_D_EXIT
#------------------------------------------------------------------------------
