#!/usr/bin/env python

#
# FIXME Needs work
#

from gnuradio import gr, eng_notation, optfir
from gnuradio import usrp
from gnuradio import audio
from gnuradio.eng_option import eng_option
from optparse import OptionParser
import math
import sys

from gnuradio.wxgui import stdgui, fftsink, scopesink
import wx


class fsk_tx_graph (stdgui.gui_flow_graph):
    def __init__(self, frame, panel, vbox, argv):
        stdgui.gui_flow_graph.__init__ (self, frame, panel, vbox, argv)

        usage="%prog: [options] file_to_transmit"
        parser = OptionParser (usage=usage, option_class=eng_option)
        parser.add_option ("-c", "--cordic-freq", type="eng_float", default=29.32e6,
                           help="set Tx cordic frequency to FREQ", metavar="FREQ")
        parser.add_option ("-R", "--repeat", action="store_true", default=False)
        parser.add_option ("-r", "--data-rate", type="eng_float", default=100e3)
        parser.add_option ("-g", "--gain", type="eng_float", default=0,
                           help="set Tx PGA gain in dB [-20, 0] (default=0)")
        parser.add_option ("-N", "--no-gui", action="store_true", default=False)
        (options, args) = parser.parse_args ()
        if len(args) != 1:
            parser.print_help()
            sys.exit(1)
        filename = args[0]
        

        print "cordic_freq = %s" % (eng_notation.num_to_str (options.cordic_freq))

        # ----------------------------------------------------------------

        data_rate = options.data_rate
        self.sw_interp = 8
        self.usrp_interp = int (128e6 / self.sw_interp / data_rate)
        self.fs = 128e6 / self.usrp_interp

        max_deviation = data_rate / 4
        payload_size = 1024             # bytes
    
        print "data_rate = ", eng_notation.num_to_str(data_rate)
        print "sw_interp = ", self.sw_interp
        print "usrp_interp = ", self.usrp_interp
        print "fs = ", eng_notation.num_to_str(self.fs)

        src = gr.file_source (gr.sizeof_char, filename, options.repeat)

        framer = gr.simple_framer (payload_size)
        
        bytes_to_syms = gr.bytes_to_syms ()

        if 1:
            interp_taps =  gr.firdes.low_pass (self.sw_interp,      # gain
                                               self.fs,             # sampling rate
                                               data_rate / 2 * 1.2, # cutoff
                                               data_rate/2 * 0.4,   # trans width
                                               gr.firdes.WIN_HANN)
        else:
            interp_taps = optfir.low_pass (self.sw_interp,      # gain
                                           self.fs,             # sampling rate
                                           data_rate/2 * 1.2,   # passband cutoff
                                           data_rate/2 * 1.6,   # stopband cutoff
                                           0.1,			# passband ripple
                                           70)                  # stopband attenuation

        print "len = ", len (interp_taps)

        interp = gr.interp_fir_filter_fff (self.sw_interp, interp_taps)

        k = 2 * math.pi * max_deviation / self.fs
        fmmod = gr.frequency_modulator_fc (k)

        self.connect (src, framer, bytes_to_syms, interp, fmmod)

        gain = gr.multiply_const_cc (16000)
        u = usrp.sink_c (0, self.usrp_interp)
        u.set_tx_freq (0, options.cordic_freq)
        u.set_pga (0, options.gain)
        u.set_pga (1, options.gain)

        self.connect (fmmod, gain, u)


        if 1 and not(options.no_gui):
            post_interp = fftsink.fft_sink_f (self, panel, title="Post Interp", fft_size=512, sample_rate=self.fs)
            self.connect (interp, post_interp)
            vbox.Add (post_interp.win, 1, wx.EXPAND)

        if 1 and not(options.no_gui):
            post_mod = fftsink.fft_sink_c (self, panel, title="Post Modulation", fft_size=512, sample_rate=self.fs)
            self.connect (fmmod, post_mod)
            vbox.Add (post_mod.win, 1, wx.EXPAND)

        if 1 and not(options.no_gui):
            post_gain = scopesink.scope_sink_f(self, panel, title="Tx Data", sample_rate=self.fs)
            c2f = gr.complex_to_float ()
            self.connect (gain, c2f)
            self.connect ((c2f, 0), (post_gain, 0))
            self.connect ((c2f, 1), (post_gain, 1))
            vbox.Add (post_gain.win, 1, wx.EXPAND)
            

def main ():
    app = stdgui.stdapp (fsk_tx_graph, "FSK Tx")
    app.MainLoop ()

if __name__ == '__main__':
    main ()
