#!/usr/bin/env python
#
# Copyright 2004 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

from gnuradio import gr
from gnuradio import audio
from optparse import OptionParser


def build_graph (dev, limit_channels):
    sampling_freq = 48000
    ampl = 0.1

    # With a tip of the hat to Harry Partch, may he R.I.P.
    # See "Genesis of a Music".  He was into some very wild tunings...
    base = 392
    ratios = { 1 : 1.0,
               3 : 3.0/2,
               5 : 5.0/4,
               7 : 7.0/4,
               9 : 9.0/8,
              11 : 11.0/8 }

    # progression = (1, 5, 3, 7)
    # progression = (1, 9, 3, 7)
    # progression = (3, 7, 9, 11)
    # progression = (7, 11, 1, 5)
    progression = (7, 11, 1, 5, 9)
    
    fg = gr.flow_graph ()
    dst = audio.sink (sampling_freq, dev)
    
    max_chan = dst.input_signature().max_streams()
    if (max_chan == -1) or (max_chan > limit_channels):
        max_chan = limit_channels

    for i in range (max_chan):
        quo, rem = divmod (i, len (progression))
        freq = base * ratios[progression[rem]] * (quo + 1)
        src = gr.sig_source_f (sampling_freq, gr.GR_SIN_WAVE, freq, ampl)
        fg.connect (src, (dst, i))

    return fg

if __name__ == '__main__':
    parser = OptionParser ()
    parser.add_option ("-d", "--device", type="string", default="hw:0,0",
                        help="pcm device name.  E.g., hw:0,0 or surround51")
    parser.add_option ("-m", "--max-channels", type="int", default="16",
                       help="set maximum channels to use")
    (options, args) = parser.parse_args ()

    fg = build_graph (options.device, int (options.max_channels))

    fg.start ()
    raw_input ('Press Enter to quit: ')
    fg.stop ()
