/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * WARNING: This file is automatically generated by generate_GrFIRfilterXXX.py
 * Any changes made to this file will be overwritten.
 */

#ifndef _GrFIRfilterFFF_H_
#define	_GrFIRfilterFFF_H_

#include <VrDecimatingSigProc.h>
#include <gr_fir_builderF.h>

class gr_fir_FFF;

/*!
 * \brief FIR filter with float input, float output and float taps
 */

class GrFIRfilterFFF : public VrDecimatingSigProc<float, float>
{
 public:
  /*!
   * Construct a FIR filter with the given taps
   */
  GrFIRfilterFFF (int decimation_factor, const std::vector<float> &taps);

  /*!
   * Construct a FIR filter where the taps will be determined
   * at initialization time by invoking builder->taps (sampling_freq)
   *
   * GrFIRfilterFFF becomes responsible for life time management
   * of builder.
   */
  GrFIRfilterFFF (int decimation_factor, gr_fir_builderF *builder);
  virtual ~GrFIRfilterFFF ();

  virtual const char *name () { return "GrFIRfilterFFF"; }
  virtual void initialize ();
  virtual int work (VrSampleRange output, void *o[],
		    VrSampleRange inputs[], void *i[]);

  void setTaps (const std::vector<float> &taps);

 protected:
  gr_fir_builderF	*d_builder;
  gr_fir_FFF		*d_fir;
  std::vector<float>	d_new_taps;
  int			d_updated;
};

#endif // _GrFIRfilterFFF_H_
