/* -*-C++-*-
*******************************************************************************
*
* File:         stereo_audio_out.cc
* Description:  
*
*******************************************************************************
*/
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <VrAudioSink.h>
#include <VrSigSource.h>
#include <VrFileSink.h>
#include <VrConnect.h>
#include <VrMultiTask.h>


const int SAMPLING_FREQ	= 8000;

/*
 * Note, on one of my machines, the left and right channels are mixed
 * together prior to output to my speakers.  I'm not sure if it's the
 * audio mixer software, the sound card or what.  The two systems are
 * running different version of Mandrake and have different audio hardware.
 *
 * Anyhow, the idea is to put a 350 Hz sine wave out one channel, and
 * a 440 Hz sine wave out the other channel.  If it's working, it'll sound
 * like US dial tone.
 */

int 
main (int argc, char **argv)
{
  // create the modules
  
  VrSigSource<short>* source0 =
    new VrSigSource<short>(SAMPLING_FREQ, VR_SIN_WAVE, 350, 8192);

  VrSigSource<short>* source1 =
    new VrSigSource<short>(SAMPLING_FREQ, VR_SIN_WAVE, 440, 8192);

  VrAudioSink<short>* sink = new VrAudioSink<short>();
  VrMultiTask *m = new VrMultiTask ();

  m->add (sink);
  
  // connect them together

  NWO_CONNECT (source0, sink);
  NWO_CONNECT (source1, sink);

  m->start ();
  while (1){
    m->process ();
  }
  m->stop ();

  return 0;
}
