/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.atomicterms;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;

public class Predicate_char_code
extends ExecuteOnlyCode {
    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        Term tchar = args[0];
        Term tcode = args[1];
        if (tchar instanceof VariableTerm) {
            VariableTerm vchar = (VariableTerm)tchar;
            if (tcode instanceof VariableTerm) {
                PrologException.instantiationError();
            } else if (!(tcode instanceof IntegerTerm)) {
                PrologException.typeError(TermConstants.integerAtom, tcode);
            }
            IntegerTerm icode = (IntegerTerm)tcode;
            if (icode.value < 0 || 65535 < icode.value) {
                PrologException.representationError(TermConstants.characterCodeAtom);
            }
            StringBuffer bu = new StringBuffer(1);
            bu.append((char)icode.value);
            interpreter.addVariableUndo(vchar);
            vchar.value = AtomTerm.get(bu.toString());
            return 1;
        }
        if (tchar instanceof AtomTerm) {
            AtomTerm achar = (AtomTerm)tchar;
            if (achar.value.length() != 1) {
                PrologException.typeError(TermConstants.characterAtom, achar);
            }
            IntegerTerm code = IntegerTerm.get(achar.value.charAt(0));
            if (!(tcode instanceof IntegerTerm | tcode instanceof VariableTerm)) {
                PrologException.typeError(TermConstants.integerAtom, tcode);
            }
            return interpreter.unify(code, tcode);
        }
        PrologException.typeError(TermConstants.characterAtom, tchar);
        return -1;
    }
}

