/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.math.Orientation;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class MultiFingerTransistor
extends EDialog {
    private static double lastLength = 3.0;
    private static double lastWidth = 15.0;
    private static double lastPitch = 0.0;
    private static double lastExtraPolyLen = 0.0;
    private static int lastNumFingers = 2;
    private static int lastNumCuts = 0;
    private static String lastTechnology = null;
    private static String lastTransistor = null;
    private static String lastContact = null;
    private boolean transistorChanging = false;
    private JButton cancel;
    private JComboBox contactChoice;
    private JTextField extraPolyLength;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JTextField length;
    private JTextField numCuts;
    private JTextField numFingers;
    private JButton ok;
    private JTextField pitch;
    private JComboBox technologyChoice;
    private JComboBox transistorChoice;
    private JTextField width;

    public static void showMultiFingerTransistorDialog() {
        MultiFingerTransistor dialog = new MultiFingerTransistor(TopLevel.getCurrentJFrame());
        dialog.setVisible(true);
    }

    private MultiFingerTransistor(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        EDialog.makeTextFieldSelectAllOnTab(this.length);
        EDialog.makeTextFieldSelectAllOnTab(this.width);
        EDialog.makeTextFieldSelectAllOnTab(this.pitch);
        EDialog.makeTextFieldSelectAllOnTab(this.numFingers);
        EDialog.makeTextFieldSelectAllOnTab(this.numCuts);
        Technology tech = Technology.getCurrent();
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology t = it.next();
            this.technologyChoice.addItem(t.getTechName());
        }
        this.technologyChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiFingerTransistor.this.technologyChanged();
            }
        });
        this.technologyChoice.setSelectedItem(tech.getTechName());
        if (lastTechnology != null) {
            this.technologyChoice.setSelectedItem(lastTechnology);
        }
        this.transistorChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiFingerTransistor.this.transistorChanged();
            }
        });
        if (lastTransistor != null) {
            this.transistorChoice.setSelectedItem(lastTransistor);
        }
        if (lastContact != null) {
            this.contactChoice.setSelectedItem(lastContact);
        }
        this.length.setText(TextUtils.formatDistance(lastLength, tech));
        this.width.setText(TextUtils.formatDistance(lastWidth, tech));
        this.pitch.setText(TextUtils.formatDistance(lastPitch, tech));
        this.extraPolyLength.setText(TextUtils.formatDistance(lastExtraPolyLen, tech));
        if (lastNumFingers > 0) {
            this.numFingers.setText(Integer.toString(lastNumFingers));
        }
        if (lastNumCuts > 0) {
            this.numCuts.setText(Integer.toString(lastNumCuts));
        }
        this.finishInitialization();
        this.pack();
    }

    private void technologyChanged() {
        String techName = (String)this.technologyChoice.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        this.transistorChanging = true;
        this.transistorChoice.removeAllItems();
        Iterator<PrimitiveNode> it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = it.next();
            if (!np.getFunction().isTransistor()) continue;
            this.transistorChoice.addItem(np.getName());
        }
        this.transistorChanging = false;
        this.transistorChanged();
        this.pack();
    }

    private void transistorChanged() {
        String transistorName;
        if (this.transistorChanging) {
            return;
        }
        String techName = (String)this.technologyChoice.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        PrimitiveNode transistorPrim = tech.findNodeProto(transistorName = (String)this.transistorChoice.getSelectedItem());
        if (transistorPrim == null) {
            System.out.println("Error in multi finger dialog: no transistor found in technology '" + tech.getTechName() + "'");
            return;
        }
        this.contactChoice.removeAllItems();
        ArcProto metalArc = MultiFingerTransistor.getMetal1(tech);
        ArcProto diffArc = null;
        Iterator<PortProto> pIt = transistorPrim.getPorts();
        block0: while (pIt.hasNext()) {
            PortProto pp = pIt.next();
            ArcProto[] arcs = pp.getBasePort().getConnections();
            for (int i = 0; i < arcs.length; ++i) {
                if (!arcs[i].getFunction().isDiffusion()) continue;
                diffArc = arcs[i];
                continue block0;
            }
        }
        Iterator<PrimitiveNode> it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode prim = it.next();
            if (!prim.getFunction().isContact()) continue;
            Iterator<PortProto> pIt2 = prim.getPorts();
            while (pIt2.hasNext()) {
                PortProto pp = pIt2.next();
                ArcProto[] arcs = pp.getBasePort().getConnections();
                boolean diffFound = false;
                boolean metalFound = false;
                for (int i = 0; i < arcs.length; ++i) {
                    if (arcs[i] == metalArc) {
                        metalFound = true;
                    }
                    if (arcs[i] != diffArc) continue;
                    diffFound = true;
                }
                if (!diffFound || !metalFound) continue;
                this.contactChoice.addItem(prim.getName());
            }
        }
        this.pack();
    }

    @Override
    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    private void cacheValues() {
        Technology tech = Technology.getCurrent();
        lastLength = TextUtils.atofDistance(this.length.getText(), tech);
        lastWidth = TextUtils.atofDistance(this.width.getText(), tech);
        lastPitch = TextUtils.atofDistance(this.pitch.getText(), tech);
        lastExtraPolyLen = TextUtils.atofDistance(this.extraPolyLength.getText(), tech);
        lastNumFingers = TextUtils.atoi(this.numFingers.getText());
        lastNumCuts = TextUtils.atoi(this.numCuts.getText());
        lastTechnology = (String)this.technologyChoice.getSelectedItem();
        lastTransistor = (String)this.transistorChoice.getSelectedItem();
        lastContact = (String)this.contactChoice.getSelectedItem();
    }

    private void makeTransistorCell() {
        this.cacheValues();
        Technology tech = Technology.findTechnology(lastTechnology);
        PrimitiveNode transistorPrim = tech.findNodeProto(lastTransistor);
        PrimitiveNode contactPrim = tech.findNodeProto(lastContact);
        if (transistorPrim == null || contactPrim == null) {
            return;
        }
        new MakeTransistorCell(transistorPrim, contactPrim, lastNumFingers, lastNumCuts, lastLength, lastWidth, lastPitch, lastExtraPolyLen).startJob();
    }

    private static ArcProto getMetal1(Technology tech) {
        Iterator<PrimitiveNode> it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode prim = it.next();
            if (!prim.getFunction().isPin()) continue;
            Iterator<PortProto> pIt = prim.getPorts();
            while (pIt.hasNext()) {
                PortProto pp = pIt.next();
                ArcProto[] arcs = pp.getBasePort().getConnections();
                for (int i = 0; i < arcs.length; ++i) {
                    if (arcs[i].getFunction() != ArcProto.Function.METAL1) continue;
                    return arcs[i];
                }
            }
        }
        return null;
    }

    private void initComponents() {
        this.cancel = new JButton();
        this.ok = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.length = new JTextField();
        this.width = new JTextField();
        this.numFingers = new JTextField();
        this.numCuts = new JTextField();
        this.jLabel6 = new JLabel();
        this.transistorChoice = new JComboBox();
        this.jLabel7 = new JLabel();
        this.pitch = new JTextField();
        this.jLabel8 = new JLabel();
        this.contactChoice = new JComboBox();
        this.jLabel9 = new JLabel();
        this.technologyChoice = new JComboBox();
        this.jLabel10 = new JLabel();
        this.extraPolyLength = new JTextField();
        this.setTitle("Multi-Finger Transistors");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MultiFingerTransistor.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiFingerTransistor.this.cancelActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiFingerTransistor.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.jLabel2.setText("Length:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Number of fingers:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("Extra Poly length:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.length.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.length, gridBagConstraints);
        this.width.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.width, gridBagConstraints);
        this.numFingers.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.numFingers, gridBagConstraints);
        this.numCuts.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.numCuts, gridBagConstraints);
        this.jLabel6.setText("Transistor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.transistorChoice, gridBagConstraints);
        this.jLabel7.setText("Pitch:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel7, gridBagConstraints);
        this.pitch.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.pitch, gridBagConstraints);
        this.jLabel8.setText("Contact:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.contactChoice, gridBagConstraints);
        this.jLabel9.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.technologyChoice, gridBagConstraints);
        this.jLabel10.setText("Number of cuts:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel10, gridBagConstraints);
        this.extraPolyLength.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.extraPolyLength, gridBagConstraints);
        this.pack();
    }

    private void okActionPerformed(ActionEvent evt) {
        this.makeTransistorCell();
        this.closeDialog(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.cacheValues();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static class MakeTransistorCell
    extends Job {
        private PrimitiveNode transistorPrim;
        private PrimitiveNode contactPrim;
        private int numFingers;
        private int numCuts;
        private double length;
        private double width;
        private double pitch;
        private double extraPolyLen;
        private String cellName;

        public MakeTransistorCell(PrimitiveNode transistorPrim, PrimitiveNode contactPrim, int numFingers, int numCuts, double length, double width, double pitch, double extraPolyLen) {
            super("Make MultiFinger Transistor", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.transistorPrim = transistorPrim;
            this.contactPrim = contactPrim;
            this.numFingers = numFingers;
            this.numCuts = numCuts;
            this.length = length;
            this.width = width;
            this.pitch = pitch;
            this.extraPolyLen = extraPolyLen;
        }

        @Override
        public boolean doIt() throws JobException {
            int f2;
            int i;
            Technology.NodeLayer nl;
            EditingPreferences ep = this.getEditingPreferences();
            this.cellName = this.transistorPrim.getFunction().getShortName() + "_L" + TextUtils.formatDouble(this.length) + "_W" + TextUtils.formatDouble(this.width) + "_NF" + this.numFingers;
            if (this.pitch > 0.0) {
                this.cellName = this.cellName + "_P" + TextUtils.formatDouble(this.pitch);
            }
            if (this.numCuts > 0) {
                this.cellName = this.cellName + "_NC" + this.numCuts;
            }
            this.cellName = this.cellName + "{lay}";
            Cell cell = Cell.makeInstance(ep, Library.getCurrent(), this.cellName);
            if (cell == null) {
                return false;
            }
            this.fieldVariableChanged("cellName");
            Technology tech = this.transistorPrim.getTechnology();
            double transWid = this.transistorPrim.getDefWidth(ep);
            double transHei = this.transistorPrim.getDefHeight(ep);
            NodeInst ni = NodeInst.makeDummyInstance((NodeProto)this.transistorPrim, ep);
            Poly[] polys = tech.getShapeOfNode(ni);
            double polyHei = 0.0;
            double diffWid = 0.0;
            for (int i2 = 0; i2 < polys.length; ++i2) {
                Poly poly = polys[i2];
                if (poly.getLayer().isDiffusionLayer()) {
                    diffWid = poly.getBounds2D().getWidth();
                }
                if (!poly.getLayer().getFunction().isPoly()) continue;
                polyHei = poly.getBounds2D().getHeight();
            }
            if (diffWid < this.width) {
                transWid += this.width - diffWid;
            }
            if (polyHei < this.length) {
                transHei += this.length - polyHei;
            }
            ArcProto metalArc = MultiFingerTransistor.getMetal1(tech);
            PrimitiveNode metalPin = metalArc.findPinProto();
            Layer gatePoly = null;
            Iterator<Layer> lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Layer lay = lIt.next();
                if (!lay.getFunction().isGatePoly()) continue;
                gatePoly = lay;
            }
            ArcProto diffArc = null;
            Iterator<PortProto> pIt = this.transistorPrim.getPorts();
            block2: while (pIt.hasNext()) {
                PortProto pp = pIt.next();
                ArcProto[] arcs = pp.getBasePort().getConnections();
                for (int i3 = 0; i3 < arcs.length; ++i3) {
                    if (!arcs[i3].getFunction().isDiffusion()) continue;
                    diffArc = arcs[i3];
                    continue block2;
                }
            }
            double contactWid = this.contactPrim.getDefWidth(ep);
            double contactHei = this.contactPrim.getDefHeight(ep);
            ni = NodeInst.makeDummyInstance((NodeProto)this.contactPrim, ep);
            polys = tech.getShapeOfNode(ni);
            diffWid = 0.0;
            for (int i4 = 0; i4 < polys.length; ++i4) {
                Poly poly = polys[i4];
                if (!poly.getLayer().isDiffusionLayer()) continue;
                diffWid = poly.getBounds2D().getWidth();
            }
            double diffOffset = contactWid - diffWid;
            if (diffWid < this.width) {
                contactWid = this.width + diffOffset;
            }
            if (this.numCuts > 0 && (nl = this.contactPrim.findMulticut()) != null) {
                double separation = nl.getMulticutSep1D().getLambda();
                double size2 = nl.getMulticutSizeY().getLambda();
                NodeInst dummyContact = NodeInst.makeDummyInstance((NodeProto)this.contactPrim, ep);
                Poly[] contactPolys = tech.getShapeOfNode(dummyContact);
                double diffSize = 0.0;
                double cutSize = 0.0;
                for (int i5 = 0; i5 < contactPolys.length; ++i5) {
                    Poly poly = contactPolys[i5];
                    if (poly.getLayer().isDiffusionLayer()) {
                        diffSize = poly.getBounds2D().getWidth();
                    }
                    if (!poly.getLayer().getFunction().isContact()) continue;
                    cutSize = poly.getBounds2D().getWidth();
                }
                double indent = diffSize - cutSize;
                double requestedDiffSize = (double)this.numCuts * size2 + (double)(this.numCuts - 1) * separation + indent;
                contactWid = requestedDiffSize + diffOffset;
            }
            NodeInst transNI = NodeInst.makeDummyInstance(this.transistorPrim, ep, EPoint.fromLambda(0.0, 0.0), transWid, transHei, Orientation.IDENT);
            Poly[] transPolys = tech.getShapeOfNode(transNI);
            double initialDistance = 1000.0;
            NodeInst contactNI = NodeInst.makeDummyInstance(this.contactPrim, ep, EPoint.fromLambda(0.0, initialDistance), contactWid, contactHei, Orientation.IDENT);
            Poly[] contactPolys = tech.getShapeOfNode(contactNI);
            double smallestExtraSpace = Double.MAX_VALUE;
            for (int t = 0; t < transPolys.length; ++t) {
                for (int c = 0; c < contactPolys.length; ++c) {
                    double extraSpace;
                    Layer contactLayer;
                    if (transPolys[t].getLayer() == contactPolys[c].getLayer()) continue;
                    double drcLen = this.length;
                    double drcWid = this.width;
                    Layer transLayer = transPolys[t].getLayer();
                    DRCTemplate rule = DRC.getSpacingRule(transLayer, null, contactLayer = contactPolys[c].getLayer(), null, true, -1, drcWid, drcLen);
                    if (rule == null && gatePoly != null && transLayer != gatePoly && transLayer.getFunction().isPoly()) {
                        rule = DRC.getSpacingRule(gatePoly, null, contactLayer, null, true, -1, drcWid, drcLen);
                    }
                    double dist = -1.0;
                    if (rule != null) {
                        dist = rule.getValue(0);
                    }
                    if (dist < 0.0 || !((extraSpace = contactPolys[c].getBounds2D().getMinY() - transPolys[t].getBounds2D().getMaxY() - dist) < smallestExtraSpace)) continue;
                    smallestExtraSpace = extraSpace;
                }
            }
            double bestPitch = initialDistance - smallestExtraSpace;
            if (this.pitch > bestPitch) {
                bestPitch = this.pitch;
            }
            bestPitch *= 2.0;
            NodeInst[] transistors = new NodeInst[this.numFingers];
            for (int f3 = 0; f3 < this.numFingers; ++f3) {
                EPoint center = EPoint.fromLambda(0.0, (double)f3 * bestPitch);
                transistors[f3] = NodeInst.makeInstance((NodeProto)this.transistorPrim, ep, center, transWid, transHei, cell, Orientation.IDENT, null);
                int index = 0;
                Iterator<PortInst> it = transistors[f3].getPortInsts();
                while (it.hasNext()) {
                    PortInst pi = it.next();
                    ArcProto[] arcs = pi.getPortProto().getBasePort().getConnections();
                    ArcProto polyArc = null;
                    for (i = 0; i < arcs.length; ++i) {
                        if (!arcs[i].getFunction().isPoly()) continue;
                        polyArc = arcs[i];
                        break;
                    }
                    if (polyArc == null) continue;
                    if (this.extraPolyLen > 0.0) {
                        ArcInst ai;
                        PortInst niPi;
                        NodeInst niPin;
                        PrimitiveNode polyPin;
                        EPoint pinCtr;
                        EPoint ctr = pi.getCenter();
                        if (ctr.getX() < 0.0) {
                            pinCtr = EPoint.fromLambda(ctr.getX() - this.extraPolyLen, ctr.getY());
                            polyPin = polyArc.findPinProto();
                            niPin = NodeInst.makeInstance(polyPin, ep, pinCtr, polyPin.getDefWidth(ep), polyPin.getDefHeight(ep), cell);
                            niPi = niPin.getOnlyPortInst();
                            ai = ArcInst.makeInstanceBase(polyArc, ep, this.length, pi, niPi);
                            ai.setTailExtended(false);
                            pi = niPi;
                        } else {
                            pinCtr = EPoint.fromLambda(ctr.getX() + this.extraPolyLen, ctr.getY());
                            polyPin = polyArc.findPinProto();
                            niPin = NodeInst.makeInstance(polyPin, ep, pinCtr, polyPin.getDefWidth(ep), polyPin.getDefHeight(ep), cell);
                            niPi = niPin.getOnlyPortInst();
                            ai = ArcInst.makeInstanceBase(polyArc, ep, this.length, pi, niPi);
                            ai.setTailExtended(false);
                            pi = niPi;
                        }
                    }
                    char suffix = (char)(97 + index++);
                    String exportName = "F" + (f3 + 1) + suffix;
                    Export.newInstance(cell, pi, exportName, ep);
                }
            }
            NodeInst[] contacts = new NodeInst[this.numFingers + 1];
            for (f2 = 0; f2 <= this.numFingers; ++f2) {
                EPoint center = EPoint.fromLambda(0.0, (double)f2 * bestPitch - bestPitch / 2.0);
                contacts[f2] = NodeInst.makeInstance((NodeProto)this.contactPrim, ep, center, contactWid, contactHei, cell, Orientation.IDENT, null);
                NodeInst pin = NodeInst.makeInstance(metalPin, ep, center, metalPin.getDefWidth(ep), metalPin.getDefHeight(ep), cell);
                ArcInst.makeInstance(metalArc, ep, contacts[f2].getOnlyPortInst(), pin.getOnlyPortInst());
                String exportName = "Act_" + (f2 + 1);
                Export.newInstance(cell, pin.getOnlyPortInst(), exportName, ep);
            }
            for (f2 = 0; f2 < this.numFingers; ++f2) {
                PortInst p1 = null;
                PortInst p2 = null;
                Iterator<PortInst> it = transistors[f2].getPortInsts();
                while (it.hasNext()) {
                    PortInst pi = it.next();
                    ArcProto[] arcs = pi.getPortProto().getBasePort().getConnections();
                    for (i = 0; i < arcs.length; ++i) {
                        if (!arcs[i].getFunction().isDiffusion()) continue;
                        if (p1 == null) {
                            p1 = pi;
                            continue;
                        }
                        p2 = pi;
                    }
                }
                if (p1.getCenter().getY() > p2.getCenter().getY()) {
                    PortInst swapPi = p1;
                    p1 = p2;
                    p2 = swapPi;
                }
                ArcInst.makeInstance(diffArc, ep, contacts[f2].getOnlyPortInst(), p1);
                ArcInst.makeInstance(diffArc, ep, p2, contacts[f2 + 1].getOnlyPortInst());
            }
            return true;
        }

        @Override
        public void terminateOK() {
            Cell cell = Library.getCurrent().findNodeProto(this.cellName);
            if (cell != null) {
                WindowFrame.createEditWindow(cell);
            }
        }
    }
}

