/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ncc.ExportTableModel;
import com.sun.electric.tool.user.ncc.HighlightTools;
import com.sun.electric.tool.user.ncc.UnrecognizedPart;
import com.sun.electric.tool.user.ncc.UnrecognizedPartTable;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class UnrecognizedPartTableModel
extends ExportTableModel {
    UnrecognizedPart[] moses;
    int[][] cellPrefHeights;
    int[][] cellPrefWidths;
    String[] colNames;

    public UnrecognizedPartTableModel(UnrecognizedPartTable parent) {
        super(parent);
        this.cellPrefHeights = this.parent.cellPrefHeights;
        this.cellPrefWidths = this.parent.cellPrefWidths;
        this.colNames = new String[]{"Cell", "Part Type"};
        this.moses = parent.moses;
        this.cellPrefHeights = parent.cellPrefHeights;
        this.cellPrefWidths = parent.cellPrefWidths;
        String href = "<a style=\"text-decoration: none\" href=\"";
        StringBuffer text2 = new StringBuffer(64);
        for (int col = 0; col < this.numCols; ++col) {
            for (int row = 0; row < this.height; ++row) {
                text2.setLength(0);
                text2.append("<html><font size=3><font face=\"Helvetica, TimesRoman\">");
                if (col == 0) {
                    CellName cellName = this.moses[row].getCell().getCellName();
                    text2.append(cellName.getName() + " " + cellName.getView().getAbbreviationExtension());
                } else {
                    text2.append(href + (row * 10 + col) + "\">" + this.moses[row].getName() + "</a>");
                }
                int[] nArray = this.cellPrefHeights[row];
                int n = col;
                nArray[n] = nArray[n] + 17;
                text2.append("</font></html>");
                JEditorPane textPane = new JEditorPane();
                textPane.setEditable(false);
                if (col == 1) {
                    textPane.addHyperlinkListener(this);
                }
                textPane.setContentType("text/html");
                textPane.setText(text2.toString());
                textPane.setMargin(this.insets);
                textPane.addMouseListener(this.mouseAdapter);
                textPane.moveCaretPosition(0);
                this.cellPrefWidths[row][col] = textPane.getPreferredSize().width + 11;
                if (this.cellPrefHeights[row][col] > 118) {
                    this.cellPrefHeights[row][col] = 118;
                }
                JPanel panel = new JPanel();
                panel.setBackground(Color.WHITE);
                panel.add(textPane);
                this.panes[row][col] = new JScrollPane(panel);
                this.panes[row][col].setBorder(BorderFactory.createEmptyBorder());
            }
        }
    }

    @Override
    protected void highlight(int index) {
        VarContext context;
        int col = index % 10;
        int row = index / 10;
        if (col != 1) {
            return;
        }
        UnrecognizedPart mos = this.moses[row];
        Cell cell = mos.getCell();
        Highlighter highlighter = HighlightTools.getHighlighter(cell, context = mos.getContext());
        if (highlighter == null) {
            return;
        }
        highlighter.addElectricObject(mos.getNodeInst(), cell);
        highlighter.finished();
    }

    @Override
    public String getColumnName(int col) {
        return this.colNames[col];
    }
}

