/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar1;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.routing.RoutingFrame;
import java.util.List;

public class CellPrinter {
    public static void printLayers(List<RoutingFrame.RoutingLayer> allLayers) {
        for (RoutingFrame.RoutingLayer layer : allLayers) {
            System.out.printf("Layer: %s, metal:%b\n", layer.getName(), layer.isMetal());
            RoutingFrame.RoutingContact pin = layer.getPin();
            if (pin == null) continue;
            System.out.printf("Pin: %s, firstLayer:%s, secondLayer:%s\n", pin.getName(), pin.getFirstLayer().getName(), pin.getSecondLayer().getName());
        }
    }

    public static void printContacts(List<RoutingFrame.RoutingContact> allContacts) {
        for (RoutingFrame.RoutingContact contact : allContacts) {
            double viaSpacing = contact.getViaSpacing();
            System.out.printf("Contact: %s, firstLayer:%s, secondLayer:%s, viaSpacing=%f\n", contact.getName(), contact.getFirstLayer().getName(), contact.getSecondLayer().getName(), viaSpacing);
        }
    }

    public static void printChipStatistics(Cell cell, List<RoutingFrame.RoutingSegment> segmentsToRoute, List<RoutingFrame.RoutingLayer> allLayers, List<RoutingFrame.RoutingContact> allContacts, List<RoutingFrame.RoutingGeometry> blockages) {
        int i;
        int metalLayers = 0;
        for (RoutingFrame.RoutingLayer rl : allLayers) {
            if (!rl.isMetal()) continue;
            ++metalLayers;
        }
        int[] layerDistance = new int[metalLayers];
        int[] layerMembership = new int[metalLayers];
        int[][] crossLayerMembership = new int[metalLayers][metalLayers];
        int singleLayer = 0;
        int crossLayer = 0;
        int maxNetID = Integer.MIN_VALUE;
        for (RoutingFrame.RoutingSegment rs : segmentsToRoute) {
            int distance;
            maxNetID = Math.max(maxNetID, rs.getNetID());
            int minStart = Integer.MAX_VALUE;
            int maxStart = Integer.MIN_VALUE;
            for (RoutingFrame.RoutingLayer rl : rs.getStartLayers()) {
                minStart = Math.min(minStart, rl.getMetalNumber());
                maxStart = Math.max(maxStart, rl.getMetalNumber());
            }
            int minFinish = Integer.MAX_VALUE;
            int maxFinish = Integer.MIN_VALUE;
            for (RoutingFrame.RoutingLayer rl : rs.getFinishLayers()) {
                minFinish = Math.min(minFinish, rl.getMetalNumber());
                maxFinish = Math.max(maxFinish, rl.getMetalNumber());
            }
            if (minStart != maxStart || minFinish != maxFinish) continue;
            int n = distance = Math.abs(minStart - minFinish);
            layerDistance[n] = layerDistance[n] + 1;
            if (minStart == minFinish) {
                ++singleLayer;
                int n2 = minStart - 1;
                layerMembership[n2] = layerMembership[n2] + 1;
                continue;
            }
            int min2 = Math.min(minStart, minFinish);
            int max2 = Math.max(minStart, minFinish);
            int[] nArray = crossLayerMembership[min2 - 1];
            int n3 = max2 - 1;
            nArray[n3] = nArray[n3] + 1;
            ++crossLayer;
        }
        int[] nets = new int[maxNetID + 1];
        for (RoutingFrame.RoutingSegment rs : segmentsToRoute) {
            int n = rs.getNetID();
            nets[n] = nets[n] + 1;
        }
        int numberOfNets = 0;
        int maxSegments = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < nets.length; ++i2) {
            if (nets[i2] != 0) {
                ++numberOfNets;
            }
            maxSegments = Math.max(maxSegments, nets[i2]);
        }
        int[] numberOfSegments = new int[maxSegments];
        for (int i3 = 0; i3 < nets.length; ++i3) {
            if (nets[i3] == 0) continue;
            int n = nets[i3] - 1;
            numberOfSegments[n] = numberOfSegments[n] + 1;
        }
        int[] blockagesOnLayer = new int[metalLayers];
        for (RoutingFrame.RoutingGeometry rg : blockages) {
            int n = rg.getLayer().getMetalNumber() - 1;
            blockagesOnLayer[n] = blockagesOnLayer[n] + 1;
        }
        System.out.println();
        System.out.println();
        System.out.print("#Metal-Layers: " + metalLayers + " { ");
        for (RoutingFrame.RoutingLayer rl : allLayers) {
            if (!rl.isMetal()) continue;
            System.out.print(rl.getMetalNumber() + ", ");
        }
        System.out.println("}\n");
        System.out.println("#Segments: " + segmentsToRoute.size());
        System.out.println("\t on one layer:  " + singleLayer);
        for (i = 0; i < layerMembership.length; ++i) {
            if (layerMembership[i] == 0) continue;
            System.out.println("\t\t Metal-" + (i + 1) + ": " + layerMembership[i]);
        }
        System.out.println("\t on two layers: " + crossLayer);
        for (i = 0; i < crossLayerMembership.length; ++i) {
            for (int j = 0; j < crossLayerMembership[0].length; ++j) {
                if (crossLayerMembership[i][j] == 0) continue;
                System.out.println("\t\t Metal-" + (i + 1) + " - Metal-" + (j + 1) + ": " + crossLayerMembership[i][j]);
            }
        }
        System.out.println();
        System.out.println("layer distance distribution");
        for (i = 0; i < layerDistance.length; ++i) {
            if (layerDistance[i] == 0) continue;
            System.out.println("\t distance " + i + ": " + layerDistance[i]);
        }
        System.out.println();
        System.out.println("#Blockages: " + blockages.size());
        for (i = 0; i < blockagesOnLayer.length; ++i) {
            if (blockagesOnLayer[i] == 0) continue;
            System.out.println("\t on Metal-" + (i + 1) + ": " + blockagesOnLayer[i]);
        }
        System.out.println();
        int countNumSegments = 0;
        System.out.println("#Nets: " + numberOfNets);
        for (int i4 = 0; i4 < numberOfSegments.length; ++i4) {
            if (numberOfSegments[i4] == 0) continue;
            countNumSegments += numberOfSegments[i4] * (i4 + 1);
            System.out.print("\t " + (i4 + 1) + " segments: " + numberOfSegments[i4] + "{ ");
            for (int j = 0; j < nets.length; ++j) {
                if (nets[j] != i4 + 1) continue;
                System.out.print(j + ", ");
            }
            System.out.println("}");
        }
        System.out.println("\tsum: " + countNumSegments + " segments");
    }
}

