/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.Main;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pref {
    private final String name;
    private PrefType type;
    private final Group group;
    private Object cachedObj;
    private Object factoryObj;
    private static final ArrayList<Group> allGroups = new ArrayList();
    private static boolean doFlushing = true;
    private static Set<Preferences> queueForFlushing;
    private static int numStrings;
    private static int lenStrings;
    private static int numValueStrings;
    private static int lenValueStrings;

    public static Group groupForPackage(Class classFromPackage) {
        return Pref.groupForPackage(classFromPackage, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Group groupForPackage(Class classFromPackage, boolean techGroup) {
        Preferences prefs = Preferences.userNodeForPackage(classFromPackage);
        if (techGroup) {
            return new Group(prefs);
        }
        ArrayList<Group> arrayList = allGroups;
        synchronized (arrayList) {
            for (Group group : allGroups) {
                if (group.preferences != prefs) continue;
                return group;
            }
            Group newGroup = new Group(prefs);
            allGroups.add(newGroup);
            return newGroup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pref(Group group, String name) {
        this.name = name;
        this.group = group;
        ArrayList arrayList = group.prefs;
        synchronized (arrayList) {
            group.prefs.add(this);
        }
    }

    public static void importPrefs(String fileName, TechPool techPool) {
        if (fileName == null) {
            return;
        }
        Pref.importPrefs(TextUtils.makeURLToFile(fileName), techPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importPrefs(URL fileURL, TechPool techPool) {
        if (fileURL == null) {
            return;
        }
        try {
            URLConnection urlCon = fileURL.openConnection();
            InputStream inputStream = urlCon.getInputStream();
            System.out.println("Importing preferences...");
            try {
                Pref.clearPrefs(Preferences.userNodeForPackage(Main.class));
            }
            catch (BackingStoreException e) {
                System.out.println("Error resetting Electric preferences");
                e.printStackTrace();
            }
            Preferences.importPreferences(inputStream);
            inputStream.close();
            Pref.delayPrefFlushing();
            ArrayList<Group> e = allGroups;
            synchronized (e) {
                for (Group group : allGroups) {
                    group.setCachedObjsFromPreferences();
                }
                for (Technology tech : techPool.values()) {
                    for (Group group : tech.getTechnologyAllPreferences()) {
                        group.setCachedObjsFromPreferences();
                    }
                }
                Setting.saveAllSettingsToPreferences();
            }
            Pref.resumePrefFlushing();
            Technology.cacheTransparentLayerColors();
        }
        catch (InvalidPreferencesFormatException e) {
            String message = "Invalid preferences format";
            if (e.getCause() instanceof SAXParseException) {
                SAXParseException se = (SAXParseException)e.getCause();
                message = message + " (line " + se.getLineNumber() + ")";
            }
            System.out.println(message + ": " + e.getMessage());
            return;
        }
        catch (IOException e) {
            System.out.println("Error reading preferences file");
            e.printStackTrace();
            return;
        }
        Job.getExtendedUserInterface().restoreSavedBindings(false);
        Job.getUserInterface().repaintAllWindows();
        System.out.println("...preferences imported from " + fileURL.getFile());
    }

    private static void clearPrefs(Preferences topNode) throws BackingStoreException {
        topNode.clear();
        for (String child : topNode.childrenNames()) {
            Pref.clearPrefs(topNode.node(child));
        }
    }

    public static void exportPrefs(String fileName) {
        if (fileName == null) {
            return;
        }
        try {
            Preferences root = Preferences.userNodeForPackage(Main.class);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            root.exportSubtree(bs);
            String xmlDump = bs.toString();
            int sunPos = xmlDump.indexOf("java.sun.com");
            String insertDTD = "";
            if (sunPos >= 0) {
                int openPos = xmlDump.lastIndexOf(60, sunPos);
                int closePos = xmlDump.indexOf(62, sunPos);
                if (openPos >= 0 && closePos >= 0) {
                    insertDTD = xmlDump.substring(openPos, closePos + 1);
                    xmlDump = xmlDump.substring(0, openPos) + xmlDump.substring(closePos + 1);
                }
            }
            StreamSource source = new StreamSource(new StringReader(xmlDump));
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", new Integer(2));
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(new OutputStreamWriter((OutputStream)bos, "utf-8"));
            transformer.transform(source, result);
            String xmlFormatted = bos.toString();
            int closePos = xmlFormatted.indexOf(62);
            if (closePos >= 0) {
                xmlFormatted = xmlFormatted.substring(0, closePos + 1) + "\n" + insertDTD + xmlFormatted.substring(closePos + 1);
            }
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            printWriter.print(xmlFormatted);
            printWriter.close();
        }
        catch (Exception e) {
            if (Job.getDebug()) {
                e.printStackTrace();
            }
            System.out.println("Error exporting Preferences");
            return;
        }
        System.out.println("Preferences saved to " + fileName);
    }

    protected void initBoolean(boolean factory) {
        this.type = PrefType.BOOLEAN;
        this.factoryObj = new Integer(factory ? 1 : 0);
        this.cachedObj = new Integer(this.group.getBoolean(this.name, factory) ? 1 : 0);
    }

    public static Pref makeBooleanPref(String name, Group group, boolean factory) {
        Pref pref = new Pref(group, name);
        pref.initBoolean(factory);
        return pref;
    }

    protected void initInt(int factory) {
        this.type = PrefType.INTEGER;
        this.factoryObj = new Integer(factory);
        this.cachedObj = new Integer(this.group.getInt(this.name, factory));
    }

    public static Pref makeIntPref(String name, Group group, int factory) {
        Pref pref = new Pref(group, name);
        pref.initInt(factory);
        return pref;
    }

    protected void initLong(long factory) {
        this.type = PrefType.LONG;
        this.factoryObj = new Long(factory);
        this.cachedObj = new Long(this.group.getLong(this.name, factory));
    }

    public static Pref makeLongPref(String name, Group group, long factory) {
        Pref pref = new Pref(group, name);
        pref.initLong(factory);
        return pref;
    }

    protected void initDouble(double factory) {
        this.type = PrefType.DOUBLE;
        this.factoryObj = new Double(factory);
        this.cachedObj = new Double(this.group.getDouble(this.name, factory));
    }

    public static Pref makeDoublePref(String name, Group group, double factory) {
        Pref pref = new Pref(group, name);
        pref.initDouble(factory);
        return pref;
    }

    protected void initString(String factory) {
        this.type = PrefType.STRING;
        this.factoryObj = new String(factory);
        this.cachedObj = new String(this.group.get(this.name, factory));
    }

    public static Pref makeStringPref(String name, Group group, String factory) {
        Pref pref = new Pref(group, name);
        pref.initString(factory);
        return pref;
    }

    public boolean getBoolean() {
        return (Integer)this.cachedObj != 0;
    }

    public int getInt() {
        return (Integer)this.cachedObj;
    }

    public long getLong() {
        return (Long)this.cachedObj;
    }

    public double getDouble() {
        return (Double)this.cachedObj;
    }

    public String getString() {
        return (String)this.cachedObj;
    }

    public Object getFactoryValue() {
        return this.factoryObj;
    }

    public boolean getBooleanFactoryValue() {
        return (Integer)this.factoryObj != 0;
    }

    public int getIntFactoryValue() {
        return (Integer)this.factoryObj;
    }

    public long getLongFactoryValue() {
        return (Long)this.factoryObj;
    }

    public double getDoubleFactoryValue() {
        return (Double)this.factoryObj;
    }

    public String getStringFactoryValue() {
        return (String)this.factoryObj;
    }

    public String getPrefName() {
        return this.name;
    }

    public Object getValue() {
        return this.cachedObj;
    }

    public PrefType getType() {
        return this.type;
    }

    public static void gatherPrefChanges() {
    }

    public static PrefChangeBatch getPrefChanges() {
        return null;
    }

    public static void implementPrefChanges(PrefChangeBatch obj) {
    }

    public static void delayPrefFlushing() {
        doFlushing = false;
        queueForFlushing = new HashSet<Preferences>();
    }

    public static void resumePrefFlushing() {
        doFlushing = true;
        for (Preferences p : queueForFlushing) {
            Pref.flushOptions(p);
        }
    }

    public void setBoolean(boolean v) {
        boolean cachedBool;
        this.checkModify();
        boolean bl = cachedBool = (Integer)this.cachedObj != 0;
        if (v != cachedBool) {
            this.cachedObj = new Integer(v ? 1 : 0);
            this.group.putBoolean(this.name, v);
        }
    }

    public void setInt(int v) {
        this.checkModify();
        int cachedInt = (Integer)this.cachedObj;
        if (v != cachedInt) {
            this.cachedObj = new Integer(v);
            this.group.putInt(this.name, v);
        }
    }

    public void setLong(long v) {
        this.checkModify();
        long cachedLong = (Long)this.cachedObj;
        if (v != cachedLong) {
            this.cachedObj = new Long(v);
            this.group.putLong(this.name, v);
        }
    }

    public void setDouble(double v) {
        this.checkModify();
        double cachedDouble = (Double)this.cachedObj;
        if (v != cachedDouble) {
            this.cachedObj = new Double(v);
            this.group.putDouble(this.name, v);
        }
    }

    public void setString(String str) {
        this.checkModify();
        String cachedString = (String)this.cachedObj;
        if (!str.equals(cachedString)) {
            this.cachedObj = new String(str);
            this.group.put(this.name, str);
        }
    }

    private void checkModify() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printAllPrefs(PrintStream out, TechPool techPool) {
        lenValueStrings = 0;
        numValueStrings = 0;
        TreeMap<String, Pref> sortedPrefs = new TreeMap<String, Pref>();
        ArrayList<Group> arrayList = allGroups;
        synchronized (arrayList) {
            for (Group group : allGroups) {
                for (Pref pref : group.prefs) {
                    sortedPrefs.put(pref.group.absolutePath() + "/" + pref.name, pref);
                }
            }
        }
        Preferences rootNode = Preferences.userRoot().node("com/sun/electric");
        lenStrings = 0;
        numStrings = 0;
        try {
            Pref.gatherPrefs(out, 0, rootNode, null);
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        out.println(lenStrings + " chars in " + numStrings + " strings");
        out.println(lenValueStrings + " chars in " + numValueStrings + " value strings");
        Setting.printAllSettings(out);
        out.println("ELECTRIC USER PREFERENCES");
        int i = 0;
        for (Pref pref : sortedPrefs.values()) {
            out.println(i++ + pref.group.absolutePath() + " " + pref.name + " " + pref.cachedObj);
        }
        for (Technology tech : techPool.values()) {
            i = 0;
            for (Group group : tech.getTechnologyAllPreferences()) {
                for (Pref pref : group.prefs) {
                    out.println(i++ + pref.group.absolutePath() + " " + tech + " " + pref.name + " " + pref.cachedObj);
                }
            }
        }
    }

    private static void gatherPrefs(PrintStream out, int level, Preferences topNode, List<String> ks) throws BackingStoreException {
        for (int i = 0; i < level; ++i) {
            out.print("  ");
        }
        String[] keys = topNode.keys();
        for (int i = 0; i < keys.length; ++i) {
            ++numStrings;
            lenStrings += keys.length;
            String value = topNode.get(keys[i], null);
            ++numValueStrings;
            lenValueStrings += value.length();
        }
        out.println(topNode.name() + " " + keys.length);
        if (topNode.absolutePath().equals("/com/sun/electric/database/hierarchy")) {
            return;
        }
        String[] children = topNode.childrenNames();
        for (int i = 0; i < children.length; ++i) {
            String childName = children[i];
            ++numStrings;
            lenStrings += children[i].length();
            Preferences childNode = topNode.node(childName);
            Pref.gatherPrefs(out, level + 1, childNode, ks);
        }
    }

    private static void flushOptions(Preferences p) {
        block2: {
            try {
                p.flush();
            }
            catch (Exception e) {
                if (Job.BATCHMODE) break block2;
                System.out.println("Failed to save preferences");
            }
        }
    }

    static {
        numValueStrings = 0;
        lenValueStrings = 0;
    }

    public static class PrefChangeBatch
    implements Serializable {
        private HashMap<String, HashMap<String, Object>> changesForNodes = new HashMap();

        private void add(Pref pref, Object newValue) {
            String nodeName = pref.group.absolutePath();
            HashMap<String, Object> changesForTheNode = this.changesForNodes.get(nodeName);
            if (changesForTheNode == null) {
                changesForTheNode = new HashMap();
                this.changesForNodes.put(nodeName, changesForTheNode);
            }
            changesForTheNode.put(pref.name, newValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PrefType {
        BOOLEAN,
        INTEGER,
        LONG,
        DOUBLE,
        STRING;

    }

    public static class Group {
        Preferences preferences;
        private final ArrayList<Pref> prefs = new ArrayList();

        public Group(Preferences preferences) {
            this.preferences = preferences;
        }

        public String absolutePath() {
            return this.preferences.absolutePath();
        }

        private void setCachedObjsFromPreferences() {
            for (Pref pref : this.prefs) {
                switch (pref.type) {
                    case BOOLEAN: {
                        pref.setBoolean(this.getBoolean(pref.name, pref.getBooleanFactoryValue()));
                        break;
                    }
                    case INTEGER: {
                        pref.setInt(this.getInt(pref.name, pref.getIntFactoryValue()));
                        break;
                    }
                    case LONG: {
                        pref.setLong(this.getLong(pref.name, pref.getLongFactoryValue()));
                        break;
                    }
                    case DOUBLE: {
                        pref.setDouble(this.getDouble(pref.name, pref.getDoubleFactoryValue()));
                        break;
                    }
                    case STRING: {
                        pref.setString(this.get(pref.name, pref.getStringFactoryValue()));
                    }
                }
            }
        }

        private void putBoolean(String key, boolean value) {
            if (this.preferences == null) {
                return;
            }
            this.preferences.putBoolean(key, value);
            if (doFlushing) {
                Pref.flushOptions(this.preferences);
            } else {
                queueForFlushing.add(this.preferences);
            }
        }

        private boolean getBoolean(String key, boolean def) {
            return this.preferences != null ? this.preferences.getBoolean(key, def) : def;
        }

        private void putInt(String key, int value) {
            if (this.preferences == null) {
                return;
            }
            this.preferences.putInt(key, value);
            if (doFlushing) {
                Pref.flushOptions(this.preferences);
            } else {
                queueForFlushing.add(this.preferences);
            }
        }

        private int getInt(String key, int def) {
            return this.preferences != null ? this.preferences.getInt(key, def) : def;
        }

        private void putLong(String key, long value) {
            if (this.preferences == null) {
                return;
            }
            this.preferences.putLong(key, value);
            if (doFlushing) {
                Pref.flushOptions(this.preferences);
            } else {
                queueForFlushing.add(this.preferences);
            }
        }

        private long getLong(String key, long def) {
            return this.preferences != null ? this.preferences.getLong(key, def) : def;
        }

        private void putDouble(String key, double value) {
            if (this.preferences == null) {
                return;
            }
            this.preferences.putDouble(key, value);
            if (doFlushing) {
                Pref.flushOptions(this.preferences);
            } else {
                queueForFlushing.add(this.preferences);
            }
        }

        private double getDouble(String key, double def) {
            return this.preferences != null ? Double.valueOf(this.preferences.getDouble(key, def)) : null;
        }

        private void put(String key, String value) {
            if (this.preferences == null) {
                return;
            }
            this.preferences.put(key, value);
            if (doFlushing) {
                Pref.flushOptions(this.preferences);
            } else {
                queueForFlushing.add(this.preferences);
            }
        }

        private String get(String key, String def) {
            return this.preferences != null ? this.preferences.get(key, def) : null;
        }
    }
}

